/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.resource.URIResolver;
import org.xml.sax.InputSource;

public class WSDLResolver
implements WSDLLocator {
    private String baseUri;
    private String importedUri;
    private InputSource inputSource;

    public WSDLResolver(String baseURI, InputSource is) {
        this.baseUri = baseURI;
        this.inputSource = is;
    }

    public InputSource getBaseInputSource() {
        return this.inputSource;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public String getLatestImportURI() {
        return this.importedUri;
    }

    public InputSource getImportInputSource(String parent, String importLocation) {
        this.baseUri = parent;
        try {
            URL parentUrl = new URL(parent);
            URL importUrl = new URL(parentUrl, importLocation);
            if (importUrl != null && !importUrl.getProtocol().startsWith("file")) {
                URLConnection con = importUrl.openConnection();
                con.setUseCaches(false);
                this.inputSource = new InputSource(con.getInputStream());
            } else {
                File file = new File(importUrl.toURI());
                if (file.exists()) {
                    URIResolver resolver2 = new URIResolver(parent.toString(), importLocation);
                    this.inputSource = new InputSource(resolver2.getInputStream());
                } else {
                    URIResolver resolver3 = new URIResolver(importLocation);
                    if (resolver3.isResolved()) {
                        this.inputSource = new InputSource(resolver3.getInputStream());
                    }
                }
            }
            this.importedUri = importUrl.toURI().toString();
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.inputSource;
    }

    public void close() {
        if (this.inputSource.getByteStream() != null) {
            try {
                this.inputSource.getByteStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

