/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.List;
import org.apache.felix.dependencymanager.Dependency;

public final class State {
    private static final String[] STATES = new String[]{"?", "inactive", "waiting for required", "tracking optional"};
    private static final int INACTIVE = 1;
    private static final int WAITING_FOR_REQUIRED = 2;
    private static final int TRACKING_OPTIONAL = 3;
    private final List m_deps;
    private final int m_state;
    private String m_stringValue;

    public State(List deps, boolean isActive) {
        this.m_deps = deps;
        if (isActive) {
            boolean allRequiredAvailable = true;
            for (int i = 0; i < deps.size(); ++i) {
                Dependency dep = (Dependency)deps.get(i);
                if (!dep.isRequired() || dep.isAvailable()) continue;
                allRequiredAvailable = false;
            }
            this.m_state = allRequiredAvailable ? 3 : 2;
        } else {
            this.m_state = 1;
        }
    }

    public boolean isInactive() {
        return this.m_state == 1;
    }

    public boolean isWaitingForRequired() {
        return this.m_state == 2;
    }

    public boolean isTrackingOptional() {
        return this.m_state == 3;
    }

    public List getDependencies() {
        return this.m_deps;
    }

    public String toString() {
        if (this.m_stringValue == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("State[" + STATES[this.m_state] + "|");
            List deps = this.m_deps;
            for (int i = 0; i < deps.size(); ++i) {
                Dependency dep = (Dependency)deps.get(i);
                buf.append("(" + dep + (dep.isRequired() ? " R" : " O") + (dep.isAvailable() ? " +" : " -") + ")");
            }
            this.m_stringValue = buf.toString();
        }
        return this.m_stringValue;
    }
}

