/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetSubscriptionResults;
import org.apache.juddi.datatype.response.SubscriptionResultsList;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.InvalidTimeException;
import org.apache.juddi.error.InvalidValueException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetSubscriptionResultsFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$GetSubscriptionResultsFunction == null ? (class$org$apache$juddi$function$GetSubscriptionResultsFunction = GetSubscriptionResultsFunction.class$("org.apache.juddi.function.GetSubscriptionResultsFunction")) : class$org$apache$juddi$function$GetSubscriptionResultsFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$GetSubscriptionResultsFunction;

    public GetSubscriptionResultsFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetSubscriptionResults request = (GetSubscriptionResults)regObject;
        String generic = request.getGeneric();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            dataStore.commit();
            SubscriptionResultsList list = new SubscriptionResultsList();
            list.setGeneric(generic);
            list.setOperator(Config.getOperator());
            SubscriptionResultsList subscriptionResultsList = list;
            return subscriptionResultsList;
        }
        catch (InvalidKeyPassedException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ex);
            throw ex;
        }
        catch (InvalidValueException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ex);
            throw ex;
        }
        catch (UnsupportedException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ex);
            throw ex;
        }
        catch (UserMismatchException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ex);
            throw ex;
        }
        catch (InvalidTimeException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ex);
            throw ex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

