/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.request.SaveBusiness;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

public class SaveBusinessFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$SaveBusinessFunction == null ? (class$org$apache$juddi$function$SaveBusinessFunction = SaveBusinessFunction.class$("org.apache.juddi.function.SaveBusinessFunction")) : class$org$apache$juddi$function$SaveBusinessFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$SaveBusinessFunction;

    public SaveBusinessFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        SaveBusiness request = (SaveBusiness)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector businessVector = request.getBusinessEntityVector();
        Vector uploadRegVector = request.getUploadRegisterVector();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (uploadRegVector != null && uploadRegVector.size() > 0) {
            throw new UnsupportedException("save_business: UploadRegistry is not supported.");
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String businessKey;
            BusinessEntity business;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            String authorizedName = publisher.getName();
            for (i = 0; i < businessVector.size(); ++i) {
                int vectorSize;
                Vector keyedRefVector;
                business = (BusinessEntity)businessVector.elementAt(i);
                businessKey = business.getBusinessKey();
                if (businessKey != null && businessKey.length() > 0 && !dataStore.isValidBusinessKey(businessKey)) {
                    throw new InvalidKeyPassedException("save_business: businessKey=" + businessKey);
                }
                if (businessKey != null && businessKey.length() > 0 && !dataStore.isBusinessPublisher(businessKey, publisherID)) {
                    throw new UserMismatchException("save_business: userID=" + publisherID + ", " + "businessKey=" + businessKey);
                }
                CategoryBag categoryBag = business.getCategoryBag();
                if (categoryBag == null || (keyedRefVector = categoryBag.getKeyedReferenceVector()) == null || (vectorSize = keyedRefVector.size()) <= 0) continue;
                for (int j = 0; j < vectorSize; ++j) {
                    KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(j);
                    String key = keyedRef.getTModelKey();
                    if (key != null && key.trim().length() != 0) continue;
                    keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
                }
            }
            for (i = 0; i < businessVector.size(); ++i) {
                business = (BusinessEntity)businessVector.elementAt(i);
                businessKey = business.getBusinessKey();
                if (businessKey != null && businessKey.length() > 0) {
                    dataStore.deleteBusiness(businessKey);
                } else {
                    business.setBusinessKey(uuidgen.uuidgen());
                }
                this.addBusinessEntityDiscoveryURL(business);
                business.setAuthorizedName(authorizedName);
                business.setOperator(Config.getOperator());
                Contacts contacts = business.getContacts();
                if (contacts == null || contacts.getContactVector() == null || contacts.getContactVector().isEmpty()) {
                    Contact contact = new Contact();
                    contact.setPersonNameValue(publisher.getName());
                    contact.setUseType("publisher");
                    String email = publisher.getEmailAddress();
                    if (email != null) {
                        contact.addEmail(new Email(email, "email"));
                    }
                    business.addContact(contact);
                }
                dataStore.saveBusiness(business, publisherID);
            }
            dataStore.commit();
            BusinessDetail detail = new BusinessDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(false);
            detail.setBusinessEntityVector(businessVector);
            BusinessDetail businessDetail = detail;
            return businessDetail;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(suppex);
            throw suppex;
        }
        catch (InvalidKeyPassedException ikpex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ikpex);
            throw ikpex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(umex);
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    private void addBusinessEntityDiscoveryURL(BusinessEntity business) {
        DiscoveryURLs discoveryURLs = business.getDiscoveryURLs();
        boolean businessEntityURLExists = false;
        String businessEntityUseType = "businessEntity";
        if (discoveryURLs != null) {
            Vector discoveryURLVector = discoveryURLs.getDiscoveryURLVector();
            if (discoveryURLVector != null) {
                String useType = null;
                for (int j = 0; j < discoveryURLVector.size(); ++j) {
                    DiscoveryURL discoveryURL = (DiscoveryURL)discoveryURLVector.get(j);
                    if (discoveryURL == null || !(useType = discoveryURL.getUseType()).equals(businessEntityUseType)) continue;
                    businessEntityURLExists = true;
                    j = discoveryURLVector.size();
                }
            }
        } else {
            business.setDiscoveryURLs(new DiscoveryURLs());
        }
        if (!businessEntityURLExists) {
            StringBuffer siteURL = new StringBuffer();
            siteURL.append(Config.getDiscoveryURL());
            siteURL.append("businesskey=");
            siteURL.append(business.getBusinessKey());
            business.addDiscoveryURL(new DiscoveryURL(businessEntityUseType, siteURL.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("juddi.useConnectionPool", "true");
        RegistryEngine reg = new RegistryEngine(props);
        reg.init();
        try {
            GetAuthToken authTokenRequest = new GetAuthToken("sviens", "password");
            AuthToken authToken = (AuthToken)reg.execute(authTokenRequest);
            AuthInfo authInfo = authToken.getAuthInfo();
            Vector<Name> nameVector = new Vector<Name>();
            nameVector.add(new Name("IBM"));
            nameVector.add(new Name("Microsoft"));
            BusinessService service = new BusinessService();
            service.setNameVector(nameVector);
            Vector<BusinessService> serviceVector = new Vector<BusinessService>();
            serviceVector.add(service);
            BusinessServices services = new BusinessServices();
            services.setBusinessServiceVector(serviceVector);
            BusinessEntity businessEntity = new BusinessEntity();
            businessEntity.setBusinessKey(null);
            businessEntity.setNameVector(nameVector);
            businessEntity.setBusinessServices(services);
            Vector<BusinessEntity> businessEntityVector = new Vector<BusinessEntity>();
            businessEntityVector.add(businessEntity);
            SaveBusiness request = new SaveBusiness();
            request.setAuthInfo(authInfo);
            request.setBusinessEntityVector(businessEntityVector);
            BusinessDetail detail = (BusinessDetail)reg.execute(request);
            System.out.println(detail);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

