/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class KeyedReferenceHandler
extends AbstractHandler {
    public static final String TAG_NAME = "keyedReference";

    protected KeyedReferenceHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        KeyedReference obj = new KeyedReference();
        obj.setTModelKey(element.getAttribute("tModelKey"));
        obj.setKeyName(element.getAttribute("keyName"));
        obj.setKeyValue(element.getAttribute("keyValue"));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String keyValue;
        String keyName;
        KeyedReference keyedRef = (KeyedReference)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String tModelKey = keyedRef.getTModelKey();
        if (tModelKey != null) {
            element.setAttribute("tModelKey", tModelKey);
        }
        if ((keyName = keyedRef.getKeyName()) != null) {
            element.setAttribute("keyName", keyName);
        }
        if ((keyValue = keyedRef.getKeyValue()) != null) {
            element.setAttribute("keyValue", keyValue);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey("uuid:3860b975-9e0c-4cec-bad6-87dfe00e3864");
        keyedRef.setKeyName("idBagKeyName2");
        keyedRef.setKeyValue("idBagKeyValue2");
        System.out.println();
        RegistryObject regObject = keyedRef;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

