/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.PublisherID;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherIDHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisherID";

    protected PublisherIDHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        PublisherID obj = new PublisherID();
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        PublisherID id = (PublisherID)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String idValue = id.getValue();
        if (idValue != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(idValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        PublisherID publisherID = new PublisherID();
        publisherID.setValue("sviens");
        System.out.println();
        RegistryObject regObject = publisherID;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

