/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Loader;

public abstract class Registry {
    private static final String CONFIG_FILE_PROPERTY_NAME = "juddi.propertiesFile";
    private static final String DEFAULT_PROPERTY_FILE = "juddi.properties";
    private static Log log = LogFactory.getLog(class$org$apache$juddi$registry$local$Registry == null ? (class$org$apache$juddi$registry$local$Registry = Registry.class$("org.apache.juddi.registry.local.Registry")) : class$org$apache$juddi$registry$local$Registry);
    private static RegistryEngine registry;
    static /* synthetic */ Class class$org$apache$juddi$registry$local$Registry;
    static /* synthetic */ Class class$java$lang$Class;

    private static void init() {
        Properties props = new Properties();
        try {
            InputStream is;
            log.debug("Loading jUDDI configuration.");
            String propFile = System.getProperty(CONFIG_FILE_PROPERTY_NAME);
            if (propFile == null || propFile.trim().length() == 0) {
                propFile = "/juddi.properties";
            }
            if ((is = Loader.getResourceAsStream(propFile)) == null) {
                log.debug("Loading " + propFile + " using the context classloader failed, trying regular classloader..");
                is = (class$java$lang$Class == null ? (class$java$lang$Class = Registry.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream(propFile);
            }
            if (is == null) {
                File configFile;
                log.debug("Loading " + propFile + " using the Class classloader failed.");
                if ("/juddi.properties".equals(propFile)) {
                    propFile = DEFAULT_PROPERTY_FILE;
                }
                if (!(configFile = new File(propFile)).exists()) {
                    log.debug("Could not find " + configFile.getAbsolutePath());
                } else {
                    log.debug("Reading juddi properties from " + configFile.getAbsolutePath());
                    is = new FileInputStream(configFile);
                }
            }
            if (is == null) {
                log.debug("Trying the classloader of the class itself. (workaround for maven2)");
                Loader loader = new Loader();
                is = loader.getResourceAsStreamFromClass(propFile);
            }
            if (is != null) {
                log.debug("Resources loaded from: " + propFile);
                props.load(is);
                is.close();
            } else {
                log.warn("Could not locate jUDDI properties '" + propFile + "'. Using defaults.");
                props.put("juddi.operatorName", "Apache.org");
                props.put("juddi.i18n.languageCode", "en");
                props.put("juddi.i18n.countryCode", "US");
                props.put("juddi.discoveryURL", "http://localhost:8080/juddi/uddiget.jsp?");
                props.put("juddi.adminEmailAddress", "nobody@apache.org");
                props.put("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
                props.put("juddi.isUseDataSource", RegistryEngine.DEFAULT_IS_USE_DATASOURCE);
                props.put("juddi.jdbcDriver", "com.mysql.jdbc.Driver");
                props.put("juddi.jdbcUrl", "jdbc:mysql://localhost/juddi");
                props.put("juddi.jdbcUsername", "juddi");
                props.put("juddi.jdbcPassword", "juddi");
                props.put("juddi.auth", "org.apache.juddi.auth.DefaultAuthenticator");
                props.put("juddi.cryptor", "org.apache.juddi.cryptor.DefaultCryptor");
                props.put("juddi.dataStore", "org.apache.juddi.datastore.jdbc.JDBCDataStore");
                props.put("juddi.uuidgen", "org.apache.juddi.uuidgen.DefaultUUIDGen");
                props.put("juddi.validator", "org.apache.juddi.validator.DefaultValidator");
                props.put("juddi.maxNameElementsAllowed", Integer.toString(5));
                props.put("juddi.maxNameLengthAllowed", Integer.toString(255));
                props.put("juddi.maxMessageSize", Integer.toString(0x200000));
                props.put("juddi.maxBusinessesPerPublisher", Integer.toString(-1));
                props.put("juddi.maxServicesPerBusiness", Integer.toString(-1));
                props.put("juddi.maxBindingsPerService", Integer.toString(-1));
                props.put("juddi.maxTModelsPerPublisher", Integer.toString(-1));
                props.put("juddi.maxRowsLimit", Integer.toString(10));
                props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                props.put("java.naming.provider.url", "jnp://localhost:1099");
                props.put("java.naming.factory.url.pkgs", "org.jboss.naming");
            }
        }
        catch (IOException ioex) {
            log.error(ioex.getMessage(), ioex);
        }
        log.debug("Initializing jUDDI components.");
        registry = new RegistryEngine(props);
        registry.init();
    }

    public void destroy() {
        log.info("jUDDI Stopping: Cleaning up existing resources.");
        RegistryEngine registry = Registry.getRegistry();
        if (registry != null) {
            registry.dispose();
        }
    }

    public static RegistryEngine getRegistry() {
        return registry;
    }

    private Registry() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Registry.init();
    }
}

