/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation;

import java.util.Hashtable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationSession;
import org.apache.ws.sandbox.security.conversation.KeyDerivator;
import org.apache.ws.sandbox.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.sandbox.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.sandbox.security.conversation.sessions.SessionMonitor;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;

public class DerivedKeyCallbackHandler
implements CallbackHandler {
    private static Log log = LogFactory.getLog((class$org$apache$ws$sandbox$security$conversation$DerivedKeyCallbackHandler == null ? (class$org$apache$ws$sandbox$security$conversation$DerivedKeyCallbackHandler = DerivedKeyCallbackHandler.class$("org.apache.ws.sandbox.security.conversation.DerivedKeyCallbackHandler")) : class$org$apache$ws$sandbox$security$conversation$DerivedKeyCallbackHandler).getName());
    public static Hashtable conversationSessionTable = new Hashtable();
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$DerivedKeyCallbackHandler;

    public static void addSecurtiyContext(String uuid, SecurityContextInfo info) {
        log.debug("DerivedKeyCallbackHandler: adding security context. Identifier: " + uuid);
        conversationSessionTable.put(uuid, new ConversationSession(info));
    }

    public static void setDerivedKeyLength(String uuid, long keyLength) throws ConversationException {
        log.debug("DerivedKeyCallbackHandler: setting derived key length: " + keyLength);
        ConversationSession session = (ConversationSession)conversationSessionTable.get(uuid);
        if (session == null) {
            throw new ConversationException("The key size cannot be set: No such context/session");
        }
        session.setKeyLength(keyLength);
    }

    public static long getDerivedKeyLength(String uuid) throws ConversationException {
        ConversationSession session = (ConversationSession)conversationSessionTable.get(uuid);
        if (session != null) {
            return session.getKeyLength();
        }
        throw new ConversationException("The key size cannot be retrieved: No such context/session");
    }

    public static ConversationSession getSession(String uuid) throws ConversationException {
        ConversationSession session = (ConversationSession)conversationSessionTable.get(uuid);
        if (session != null) {
            return session;
        }
        return null;
    }

    public static void setLabelForSession(String uuid, String label) throws ConversationException {
        ConversationSession session = (ConversationSession)conversationSessionTable.get(uuid);
        if (session == null) {
            throw new ConversationException("The key size cannot be set: No such context/session");
        }
        session.setLabel(label);
    }

    public void addDerivedKey(String uuid, DerivedKeyInfo dkInfo) throws ConversationException {
        log.debug("DerivedKeyCallbackHandler: Adding derived key Id: " + dkInfo.getId() + " to session: " + uuid);
        ConversationSession convSess = (ConversationSession)conversationSessionTable.get(uuid);
        if (convSess == null) {
            throw new ConversationException("Session cannot be found");
        }
        ((ConversationSession)conversationSessionTable.get(uuid)).addDerivedKey(dkInfo);
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            String keyId = pc.getIdentifer();
            log.debug("DerivedKeyCallbackHandler: Requesting key for callback id: " + keyId);
            KeyDerivator kd = new KeyDerivator();
            try {
                pc.setKey(kd.generateKey(conversationSessionTable, keyId));
                continue;
            }
            catch (ConversationException ex1) {
                ex1.printStackTrace();
                continue;
            }
            catch (WSSecurityException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log.debug("DerivedKeyCallbackHandler: Creating a session monitor");
        try {
            SessionMonitor sm = new SessionMonitor(conversationSessionTable);
            sm.start();
        }
        catch (ConversationException ex) {
            ex.printStackTrace();
        }
    }
}

