/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2.samples;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.axis.AxisFault;
import org.apache.ws.sandbox.security.trust2.Lifetime;
import org.apache.ws.sandbox.security.trust2.RequestSecurityToken;
import org.apache.ws.sandbox.security.trust2.RequestSecurityTokenResponse;
import org.apache.ws.sandbox.security.trust2.SecurityTokenOrReference;
import org.apache.ws.sandbox.security.trust2.TokenTypes;
import org.apache.ws.sandbox.security.trust2.TrustConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.w3c.dom.Document;

public class SampleSecurityTokenService {
    public RequestSecurityTokenResponse exchange(RequestSecurityToken tokenRequest) throws AxisFault {
        if (tokenRequest != null && TrustConstants.REQUEST_ISSUE.equals(tokenRequest.getRequestType())) {
            SecurityTokenOrReference requestedToken = null;
            Document doc = tokenRequest.getDocument();
            if (TokenTypes.X509.equals(tokenRequest.getTokenType())) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICTTCCAbagAwIBAgIDC6tXMA0GCSqGSIb3DQEBBAUAMGExCzAJBgNVBAYTAkRFMQ8wDQYDVQQIEwZCYXllcm4xDzANBgNVBAcTBk11bmljaDEPMA0GA1UEChMGQXBhY2hlMQ4wDAYDVQQLEwVXU1M0SjEPMA0GA1UEAxMGV2VybmVyMB4XDTA0MDUxMDA2MjgzMloXDTA0MDUxMDE4MzMzMlowdjELMAkGA1UEBhMCREUxDzANBgNVBAgTBkJheWVybjEPMA0GA1UEBxMGTXVuaWNoMQ8wDQYDVQQKEwZBcGFjaGUxDjAMBgNVBAsTBVdTUzRKMQ8wDQYDVQQDEwZXZXJuZXIxEzARBgNVBAMTCjEzNDU1MDc0NzQwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAJbir9ayJesk3Yj+L1gDlS8TbtEj5DYLMhIYDA/Ycef2WEQ+pNIPTpeZ27SYEgf8Kmxpt4HHE5WJ8M9wnpB6EDQwi8vIQLTkaemJHGuWH8rbFY4CwFtQKEro63+agiSzbWZkpOFX4RFyX/Y5lOgZcW0q0yhumG2ZdMKViS81gx4BAgMBAAEwDQYJKoZIhvcNAQEEBQADgYEAPxYMCzAIoe0/DhT2NPpfl8+3vHV33YIbzlaejoV47KeR9IjPvKNS3PK0Mke3eKgJo/11DplnVpx9inKYaatPT/ZRz0eJ1+oTPe1kRYMDhO/OWCZhvVWQZPA9M8TWrDWJKwa6HlEmsbZGMnoGwEQ+7S3eD9TsqFf83CD+6Yr8wkM=\n-----END CERTIFICATE-----".getBytes());
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
                    X509Security binaryToken = new X509Security(WSSConfig.getDefaultWSConfig(), doc);
                    binaryToken.setX509Certificate(cert);
                    requestedToken = new SecurityTokenOrReference(binaryToken);
                }
                catch (Exception e) {
                    throw new AxisFault("Could not create X.509 Security Token: " + e.getMessage());
                }
            } else if (TokenTypes.USERNAME.equals(tokenRequest.getTokenType())) {
                UsernameToken userToken = new UsernameToken(WSSConfig.getDefaultWSConfig(), doc);
                userToken.setName("bob");
                userToken.setPassword("bobspass");
                requestedToken = new SecurityTokenOrReference(userToken);
            }
            RequestSecurityTokenResponse tokenResponse = new RequestSecurityTokenResponse(doc, requestedToken);
            tokenResponse.setContext(tokenRequest.getContext());
            tokenResponse.setTokenType(tokenRequest.getTokenType());
            Lifetime lifetime = tokenRequest.getLifetime();
            tokenResponse.setLifetime(lifetime);
            if (tokenRequest.getCustomElement("http://testElementNs.testElementNs", "TestElement") != null) {
                tokenResponse.addCustomElementNS("http://testElementNs.testElementNs", "te:TestElementResponse");
            }
            return tokenResponse;
        }
        return null;
    }
}

