/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver = RSAKeyValueResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver).getName());
    private Element _rsaKeyElement = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return false;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue");
        if (bl) {
            this._rsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
            if (this._rsaKeyElement != null) {
                return true;
            }
        } else if (bl2) {
            this._rsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        boolean bl;
        if (!(this._rsaKeyElement != null || (bl = this.engineCanResolve(element, string, storageResolver)) && this._rsaKeyElement != null)) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this._rsaKeyElement, string);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

