/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;

public class HierarchyScope
extends AbstractSearchScope
implements SuffixConstants {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;

    public void add(IResource element) {
        if (this.elementCount == this.elements.length) {
            this.elements = new IResource[this.elementCount * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
        }
        this.elements[this.elementCount++] = element;
    }

    /*
     * WARNING - void declaration
     */
    public HierarchyScope(IType type, WorkingCopyOwner owner) throws JavaModelException {
        this.focusType = type;
        this.owner = owner;
        this.enclosingProjectsAndJars = this.computeProjectsAndJars(type);
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            void var6_6;
            String zipFileName;
            IPath jarPath = root.getPath();
            Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), jarPath, true);
            if (target instanceof IFile) {
                zipFileName = jarPath.toString();
            } else if (target instanceof File) {
                zipFileName = ((File)target).getPath();
            } else {
                return;
            }
            this.focusPath = String.valueOf(var6_6) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
        } else {
            this.focusPath = type.getPath().toString();
        }
        this.needsRefresh = true;
    }

    /*
     * WARNING - void declaration
     */
    private void buildResourceVector() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        this.types = this.hierarchy.getAllTypes();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < this.types.length) {
            block8: {
                IType type;
                block5: {
                    void var11_11;
                    IPath jarPath;
                    block7: {
                        String zipFileName;
                        Object target;
                        block6: {
                            IPackageFragmentRoot root;
                            type = this.types[i];
                            IResource resource = type.getResource();
                            if (resource != null && resources.get(resource) == null) {
                                resources.put(resource, resource);
                                this.add(resource);
                            }
                            if (!((root = (IPackageFragmentRoot)type.getPackageFragment().getParent()) instanceof JarPackageFragmentRoot)) break block5;
                            JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
                            jarPath = jar.getPath();
                            target = JavaModel.getTarget((IContainer)workspaceRoot, jarPath, true);
                            if (!(target instanceof IFile)) break block6;
                            zipFileName = jarPath.toString();
                            break block7;
                        }
                        if (!(target instanceof File)) break block8;
                        zipFileName = ((File)target).getPath();
                    }
                    String resourcePath = String.valueOf(var11_11) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
                    this.resourcePaths.add(resourcePath);
                    paths.put(jarPath, type);
                    break block8;
                }
                paths.put(type.getJavaProject().getProject().getFullPath(), type);
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType type) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject[] projects = model.getJavaProjects();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < projects.length) {
                JavaProject project = (JavaProject)projects[i];
                IClasspathEntry[] classpath = project.getResolvedClasspath(true, false, false);
                int j = 0;
                while (j < classpath.length) {
                    if (rootPath.equals((Object)classpath[j].getPath())) {
                        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                        set.add(project.getPath());
                        int k = 0;
                        while (k < roots.length) {
                            IPackageFragmentRoot pkgFragmentRoot = roots[k];
                            if (pkgFragmentRoot.getKind() == 2) {
                                set.add(pkgFragmentRoot.getPath());
                            }
                            ++k;
                        }
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            IJavaProject project = (IJavaProject)root.getParent();
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 2) {
                    set.add(pkgFragmentRoot.getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IJavaProject dependent = JavaCore.create(dependents[i]);
                IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths.contains(resourcePath);
        }
        int i = 0;
        while (i < this.elementCount) {
            if (resourcePath.startsWith(this.elements[i].getFullPath().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(element.getAncestor(7))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            IType original;
            if (this.hierarchy.contains(type)) {
                return true;
            }
            if (!type.isBinary() && (original = (IType)type.getPrimaryElement()) != null) {
                return this.hierarchy.contains(original);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    protected void initialize() throws JavaModelException {
        this.resourcePaths = new HashSet();
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.focusType.newTypeHierarchy(this.owner, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    public void processDelta(IJavaElementDelta delta) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta);
    }

    protected void refresh() throws JavaModelException {
        if (this.hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors();
    }
}

