/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.InParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class InOutputParameterForCallableStatement
extends OutputParameterForCallableStatement {
    protected Object inParameter;

    public InOutputParameterForCallableStatement(Object inParameter, OutputParameterForCallableStatement outParameter) {
        super(outParameter);
        this.inParameter = inParameter == null ? this.getOutputField() : inParameter;
    }

    public InOutputParameterForCallableStatement(Object inParameter, DatabaseField outField, AbstractSession session) {
        if (outField.getType() == null && inParameter != null) {
            DatabaseField typeField = (DatabaseField)outField.clone();
            if (inParameter instanceof DatabaseField) {
                typeField.setType(((DatabaseField)inParameter).getType());
            } else if (inParameter instanceof InParameterForCallableStatement) {
                typeField.setType(((InParameterForCallableStatement)inParameter).getType());
            } else {
                typeField.setType(inParameter.getClass());
            }
            outField = typeField;
        }
        this.obj = outField;
        this.prepare(session);
        this.inParameter = inParameter == null ? this.getOutputField() : inParameter;
    }

    public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        platform.setParameterValueInDatabaseCall(this.inParameter, statement, index, session);
        super.set(platform, statement, index, session);
    }

    public String toString() {
        String strIn = this.inParameter instanceof DatabaseField ? "null" : this.inParameter.toString();
        return strIn + " " + super.toString();
    }
}

