/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(ClassDescriptor desc) {
        super(desc);
    }

    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (!this.shouldUseClassNameAsIndicator() && this.namespaceResolver != null) {
            for (Object key : new HashMap(this.getClassIndicatorMapping()).keySet()) {
                QName qname;
                Object value = this.getClassIndicatorMapping().get(key);
                if (!(key instanceof String)) continue;
                String indicatorValue = (String)key;
                int index = indicatorValue.indexOf(":");
                if (index != -1) {
                    String prefix = indicatorValue.substring(0, index);
                    String localPart = indicatorValue.substring(index + 1);
                    String uri = this.namespaceResolver.resolveNamespacePrefix(prefix);
                    qname = new QName(uri, localPart);
                } else {
                    qname = this.namespaceResolver != null ? new QName(this.namespaceResolver.getDefaultNamespaceURI(), indicatorValue) : new QName(indicatorValue);
                }
                this.getClassIndicatorMapping().put(qname, value);
            }
        }
        if (this.getClassIndicatorField() != null) {
            XMLField classIndicatorXMLField;
            try {
                classIndicatorXMLField = (XMLField)this.getClassIndicatorField();
            }
            catch (ClassCastException ex) {
                classIndicatorXMLField = new XMLField(this.getClassIndicatorField().getName());
                this.setClassIndicatorField(classIndicatorXMLField);
            }
            XPathFragment frag = classIndicatorXMLField.getLastXPathFragment();
            if (frag != null && frag.hasNamespace() && this.namespaceResolver != null) {
                String uri = this.namespaceResolver.resolveNamespacePrefix(frag.getPrefix());
                classIndicatorXMLField.getLastXPathFragment().setNamespaceURI(uri);
            }
        }
    }

    public Class classFromRow(AbstractRecord rowFromDatabase, AbstractSession session) throws DescriptorException {
        Class concreteClass;
        ((XMLRecord)rowFromDatabase).setSession(session);
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(rowFromDatabase, session);
        }
        Object indicator = rowFromDatabase.get(this.getClassIndicatorField());
        if (indicator == AbstractRecord.noEntry) {
            return null;
        }
        Object classFieldValue = session.getDatasourcePlatform().getConversionManager().convertObject(indicator, this.getClassIndicatorField().getType());
        if (classFieldValue == null) {
            return null;
        }
        if (classFieldValue instanceof String) {
            String indicatorValue = (String)classFieldValue;
            int index = indicatorValue.indexOf(":");
            if (index == -1) {
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(null);
                if (uri == null) {
                    concreteClass = (Class)this.classIndicatorMapping.get(classFieldValue);
                } else {
                    QName qname = new QName(uri, indicatorValue);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                }
            } else {
                String prefix = indicatorValue.substring(0, index);
                String localPart = indicatorValue.substring(index + 1);
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(prefix);
                if (uri != null) {
                    QName qname = new QName(uri, localPart);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                } else {
                    concreteClass = (Class)this.classIndicatorMapping.get(indicatorValue);
                }
            }
        } else {
            concreteClass = (Class)this.classIndicatorMapping.get(classFieldValue);
        }
        if (concreteClass == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(classFieldValue, this.getDescriptor());
        }
        return concreteClass;
    }

    public void setNamespaceResolver(NamespaceResolver resolver2) {
        this.namespaceResolver = resolver2;
    }

    public void setClassIndicatorFieldName(String fieldName) {
        if (fieldName == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new XMLField(fieldName));
        }
    }
}

