/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class NestedTableMapping
extends CollectionMapping {
    protected DatabaseMapping nestedMapping;
    protected DatabaseField field;
    protected String structureName;

    public Object clone() {
        NestedTableMapping clone = (NestedTableMapping)super.clone();
        return clone;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression exp) {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionCriteria = builder.ref().equal(builder.value());
        return exp.getBaseExpression().twist(selectionCriteria, exp);
    }

    public String getStructureName() {
        return this.structureName;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)this.getField();
        field.setSqlType(2003);
        field.setSqlTypeName(this.getStructureName());
        this.setField(this.getDescriptor().buildField(this.getField()));
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression queryKey = builder.getManualQueryKey(this.getAttributeName(), this.getDescriptor());
        Expression exp1 = builder.ref().equal(queryKey.get(this.getAttributeName()).value());
        Expression exp2 = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().rebuildOn(queryKey);
        this.setSelectionCriteria(exp1.and(exp2));
    }

    public boolean isNestedTableMapping() {
        return true;
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        this.initializeSelectionCriteria(session);
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object objectsIterator = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(objectsIterator)) {
            DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
            deleteQuery.setIsExecutionClone(true);
            deleteQuery.setObject(containerPolicy.next(objectsIterator, query.getSession()));
            deleteQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(deleteQuery);
        }
        if (!query.getSession().isUnitOfWork()) {
            this.verifyDeleteForUpdate(query);
        }
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void preUpdate(WriteObjectQuery writeQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        Object objectsInMemoryModel = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), writeQuery.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(writeQuery);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objectsInMemoryModel, writeQuery);
    }

    protected void setField(DatabaseField theField) {
        this.field = theField;
    }

    public void setFieldName(String FieldName2) {
        this.setField(new ObjectRelationalDatabaseField(FieldName2));
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord record, AbstractSession session) {
        Array array;
        if (this.isReadOnly()) {
            return;
        }
        Object values = this.getRealCollectionAttributeValueFromObject(object, session);
        ContainerPolicy cp = this.getContainerPolicy();
        Object[] fields = new Object[cp.sizeFor(values)];
        Object valuesIterator = cp.iteratorFor(values);
        for (int index = 0; index < cp.sizeFor(values); ++index) {
            Object value = cp.next(valuesIterator, session);
            fields[index] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(value, session);
        }
        try {
            ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
            Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
            array = session.getPlatform().createArray(this.getStructureName(), fields, session, connection);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, session.getAccessor(), session, false);
        }
        finally {
            ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
        }
        record.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        Array array;
        if (this.isReadOnly()) {
            return;
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        Object values = this.getRealAttributeValueFromObject(object, session);
        ContainerPolicy containterPolicy = this.getContainerPolicy();
        if (values == null) {
            values = containterPolicy.containerInstance(1);
        }
        Object[] fields = new Object[containterPolicy.sizeFor(values)];
        Object valuesIterator = containterPolicy.iteratorFor(values);
        for (int index = 0; index < containterPolicy.sizeFor(values); ++index) {
            Object value = containterPolicy.next(valuesIterator, session);
            fields[index] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(value, session);
        }
        try {
            ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
            Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
            array = session.getPlatform().createArray(this.getStructureName(), fields, session, connection);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, session.getAccessor(), session, false);
        }
        finally {
            ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
        }
        record.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord record) throws DescriptorException {
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        if (writeQuery.getSession().isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), writeQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), record, writeQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }
}

