/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerRecord
extends MarshalRecord {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private String namespaceURI;
    private XPathFragment xPathFragment;
    private AttributesImpl attributes;
    private static final String CDATA = "CDATA";
    protected boolean isStartElementOpen = false;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void startDocument(String encoding, String version2) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
        try {
            this.contentHandler.startPrefixMapping(prefix, namespaceURI);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endPrefixMapping(String prefix) {
        try {
            this.contentHandler.endPrefixMapping(prefix);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    private void openAndCloseStartElement() {
        try {
            this.contentHandler.startElement(this.namespaceURI, this.xPathFragment.getLocalName(), this.xPathFragment.getShortName(), this.attributes);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.xPathFragment = xPathFragment;
        this.attributes = new AttributesImpl();
    }

    public void element(String namespaceURI, String localName, String qName) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.attributes = new AttributesImpl();
            this.contentHandler.startElement(namespaceURI, localName, qName, this.attributes);
            this.contentHandler.endElement(namespaceURI, localName, qName);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        String namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.attributes.addAttribute(namespaceURI, xPathFragment.getLocalName(), xPathFragment.getShortName(), CDATA, value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.attributes.addAttribute(namespaceURI, localName, qName, CDATA, value);
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            String namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
            this.contentHandler.endElement(namespaceURI, xPathFragment.getLocalName(), xPathFragment.getShortName());
            this.isStartElementOpen = false;
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.contentHandler.characters(value.toCharArray(), 0, value.length());
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
            this.characters(value);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }
        catch (SAXException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            if (node.getNodeType() == 3) {
                this.characters(node.getNodeValue());
            } else {
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(this.contentHandler);
                try {
                    xfragReader.parse(node);
                }
                catch (SAXException sex) {
                    throw XMLMarshalException.marshalException(sex);
                }
            }
        }
    }

    public String resolveNamespacePrefix(XPathFragment frag, NamespaceResolver resolver2) {
        String resolved = super.resolveNamespacePrefix(frag, resolver2);
        if (resolved == null) {
            return "";
        }
        return resolved;
    }

    public String resolveNamespacePrefix(String s) {
        String resolved = super.resolveNamespacePrefix(s);
        if (resolved == null) {
            return "";
        }
        return resolved;
    }
}

