/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

public class EntityAccessStrategyAdapter
implements EntityRegionAccessStrategy {
    private final EntityRegion region;
    private final CacheConcurrencyStrategy ccs;
    private final Settings settings;

    public EntityAccessStrategyAdapter(EntityRegion region, CacheConcurrencyStrategy ccs, Settings settings) {
        this.region = region;
        this.ccs = ccs;
        this.settings = settings;
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.ccs.get(key, txTimestamp);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version2) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version2, this.settings.isMinimalPutsEnabled());
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version2, boolean minimalPutOverride) throws CacheException {
        return this.ccs.put(key, value, txTimestamp, version2, this.region.getCacheDataDescription().getVersionComparator(), minimalPutOverride);
    }

    public SoftLock lockItem(Object key, Object version2) throws CacheException {
        return this.ccs.lock(key, version2);
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.ccs.release(key, lock);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        if (!this.region.isTransactionAware()) {
            this.ccs.clear();
        }
    }

    public boolean insert(Object key, Object value, Object version2) throws CacheException {
        return this.ccs.insert(key, value, version2);
    }

    public boolean afterInsert(Object key, Object value, Object version2) throws CacheException {
        return this.ccs.afterInsert(key, value, version2);
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return this.ccs.update(key, value, currentVersion, previousVersion);
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return this.ccs.afterUpdate(key, value, currentVersion, lock);
    }

    public void remove(Object key) throws CacheException {
        this.ccs.evict(key);
    }

    public void removeAll() throws CacheException {
        this.ccs.clear();
    }

    public void evict(Object key) throws CacheException {
        this.ccs.remove(key);
    }

    public void evictAll() throws CacheException {
        this.ccs.clear();
    }

    public void destroy() {
        this.ccs.destroy();
    }
}

