/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.configuration;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IndexWriterSetting implements Serializable
{
    MAX_BUFFERED_DELETE_TERMS("max_buffered_delete_terms"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setMaxBufferedDeleteTerms(value);
        }
    }
    ,
    MAX_BUFFERED_DOCS("max_buffered_docs"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setMaxBufferedDocs(value);
        }
    }
    ,
    MAX_FIELD_LENGTH("max_field_length"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setMaxFieldLength(value);
        }
    }
    ,
    MAX_MERGE_DOCS("max_merge_docs"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setMaxMergeDocs(value);
        }
    }
    ,
    MERGE_FACTOR("merge_factor"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setMergeFactor(value);
        }
    }
    ,
    RAM_BUFFER_SIZE("ram_buffer_size"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setRAMBufferSizeMB(value);
        }
    }
    ,
    TERM_INDEX_INTERVAL("term_index_interval"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setTermIndexInterval(value);
        }
    }
    ,
    USE_COMPOUND_FILE("use_compound_file"){

        public void applySetting(IndexWriter writer, int value) {
            writer.setUseCompoundFile(IndexWriterSetting.intToBoolean(value));
        }

        public Integer parseVal(String value) {
            return 8.USE_COMPOUND_FILE.parseBoolean(value);
        }
    };

    private static final Integer TRUE;
    private static final Integer FALSE;
    private final String cfgKey;

    private IndexWriterSetting(String configurationKey) {
        this.cfgKey = configurationKey;
    }

    public abstract void applySetting(IndexWriter var1, int var2);

    public String getKey() {
        return this.cfgKey;
    }

    public Integer parseVal(String value) {
        return ConfigurationParseHelper.parseInt(value, "Invalid value for " + this.cfgKey + ": " + value);
    }

    private Integer parseBoolean(String value) {
        boolean v = ConfigurationParseHelper.parseBoolean(value, "Invalid value for " + this.cfgKey + ": " + value);
        return v ? TRUE : FALSE;
    }

    private static boolean intToBoolean(int value) {
        return value == TRUE;
    }

    static {
        TRUE = 1;
        FALSE = 0;
    }
}

