/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.IndexInteractionType;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class DeleteExtWorkDelegate
extends DeleteWorkDelegate {
    private final Class managedType;
    private final DocumentBuilderIndexedEntity builder;
    private final Logger log = LoggerFactory.make();

    DeleteExtWorkDelegate(Workspace workspace) {
        super(workspace);
        if (workspace.getEntitiesInDirectory().size() != 1) {
            throw new AssertionFailure("Can't use this delegate on shared indexes");
        }
        this.managedType = workspace.getEntitiesInDirectory().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
    }

    public IndexInteractionType getIndexInteractionType() {
        return IndexInteractionType.PREFER_INDEXREADER;
    }

    public void performWork(LuceneWork work, IndexWriter writer) {
        this.checkType(work);
        Serializable id = work.getId();
        this.log.trace("Removing {}#{} by id using an IndexWriter.", this.managedType, (Object)id);
        Term idTerm = this.builder.getTerm(id);
        try {
            writer.deleteDocuments(idTerm);
        }
        catch (Exception e) {
            String message = "Unable to remove " + this.managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    public void performWork(LuceneWork work, IndexReader reader) {
        this.checkType(work);
        Serializable id = work.getId();
        this.log.trace("Removing {}#{} by id using an IndexReader.", this.managedType, (Object)id);
        Term idTerm = this.builder.getTerm(id);
        try {
            reader.deleteDocuments(idTerm);
        }
        catch (Exception e) {
            String message = "Unable to remove " + this.managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type");
        }
    }
}

