/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotEmptyValidator
implements Validator<NotEmpty>,
PropertyConstraint,
Serializable {
    @Override
    public void initialize(NotEmpty parameters) {
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() > 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size() > 0;
        }
        return ((String)value).length() > 0;
    }

    @Override
    public void apply(Property property) {
        if (!(property.getPersistentClass() instanceof SingleTableSubclass || property.getValue() instanceof Collection || property.isComposite())) {
            Iterator iter = property.getColumnIterator();
            while (iter.hasNext()) {
                ((Column)iter.next()).setNullable(false);
            }
        }
    }
}

