/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.InboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

class InboundConsumer
implements ServerSessionPool {
    private WorkManager workManager;
    private MessageEndpointFactory endpointFactory;
    private XAConnection cnx;
    private String subName = null;
    private boolean transacted;
    private int maxWorks;
    private int ackMode;
    private boolean closeDurSub;
    private ConnectionConsumer cnxConsumer;
    private int serverSessions = 0;
    private Vector pool;

    InboundConsumer(WorkManager workManager, MessageEndpointFactory endpointFactory, XAConnection cnx, Destination dest, String selector, boolean durable, String subName, boolean transacted, int maxWorks, int maxMessages, int ackMode, boolean closeDurSub) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("InboundConsumer(" + workManager + ", " + endpointFactory + ", " + cnx + ", " + dest + ", " + selector + ", " + durable + ", " + subName + ", " + transacted + ", " + maxWorks + ", " + maxMessages + "," + ackMode + "," + closeDurSub + ")"));
        }
        this.workManager = workManager;
        this.endpointFactory = endpointFactory;
        this.cnx = cnx;
        this.transacted = transacted;
        this.ackMode = ackMode;
        if (maxWorks < 0) {
            maxWorks = 0;
        }
        this.maxWorks = maxWorks;
        this.pool = new Vector(maxWorks);
        try {
            if (durable) {
                if (!(dest instanceof Topic)) {
                    throw new NotSupportedException("Can't set a durable subscription on a JMS queue.");
                }
                if (subName == null) {
                    throw new NotSupportedException("Missing durable subscription name.");
                }
                this.subName = subName;
                this.cnxConsumer = cnx.createDurableConnectionConsumer((Topic)dest, subName, selector, this, maxMessages);
            } else {
                this.cnxConsumer = cnx.createConnectionConsumer(dest, selector, this, maxMessages);
            }
            cnx.start();
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Target destination not readble: " + exc);
        }
        catch (IllegalStateException exc) {
            throw new CommException("Connection with the JORAM server is lost.");
        }
        catch (JMSException exc) {
            throw new ResourceException("Could not set asynchronous consumer: " + exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getServerSession()"));
        }
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                if (this.pool.isEmpty()) {
                    if (this.maxWorks > 0) {
                        if (this.serverSessions < this.maxWorks) {
                            return this.newSession();
                        }
                        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"ServerSessionPool waits for a free ServerSession.");
                        }
                        this.pool.wait();
                        return (ServerSession)this.pool.remove(0);
                    }
                    return this.newSession();
                }
                return (ServerSession)this.pool.remove(0);
            }
        }
        catch (Exception exc) {
            throw new JMSException("Error while getting server session from pool: " + exc);
        }
    }

    private InboundSession newSession() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"ServerSessionPool provides new ServerSession.");
        }
        ++this.serverSessions;
        return new InboundSession(this, this.workManager, this.endpointFactory, this.cnx, this.transacted, this.ackMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSession(InboundSession session) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " releaseSession(" + session + ")"));
        }
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                this.pool.add(session);
                this.pool.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " close() unsubscribe subscription: " + this.closeDurSub));
        }
        try {
            this.cnxConsumer.close();
            if (this.closeDurSub && this.subName != null) {
                Session session = this.cnx.createSession(true, 0);
                session.unsubscribe(this.subName);
            }
            this.cnx.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

