/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownNotificationException;
import fr.dyade.aaa.agent.WakeUpTask;
import fr.dyade.aaa.util.TimerTask;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.ClientContext;
import org.objectweb.joram.mom.proxies.CloseConnectionNot;
import org.objectweb.joram.mom.proxies.ConnectionContext;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.proxies.ProxyImpl;
import org.objectweb.joram.mom.proxies.ProxyRequestGroupNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.RequestBuffer;
import org.objectweb.joram.mom.proxies.RequestNot;
import org.objectweb.joram.mom.proxies.ResetCollocatedConnectionsNot;
import org.objectweb.joram.mom.proxies.ReturnConnectionNot;
import org.objectweb.joram.mom.proxies.SendRepliesNot;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.ServerReply;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.util.monolog.api.BasicLevel;

public class UserAgent
extends Agent
implements BagSerializer,
ProxyAgentItf {
    private static final long serialVersionUID = 1L;
    private ProxyImpl proxyImpl;
    private transient Hashtable connections;
    private transient Hashtable heartBeatTasks;
    private int keyCounter;
    private transient WakeUpTask cleaningTask;

    public UserAgent() {
        super(true);
        this.init();
    }

    public UserAgent(int stamp) {
        super("JoramAdminProxy", true, stamp);
        this.init();
    }

    private void init() {
        this.proxyImpl = new ProxyImpl(this);
        this.keyCounter = 0;
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent.agentInitialize(" + firstTime + ')'));
        }
        super.agentInitialize(firstTime);
        this.proxyImpl.initialize(firstTime);
        this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class);
        this.cleaningTask.schedule(this.proxyImpl.getPeriod());
        try {
            MXWrapper.registerMBean(this.proxyImpl, "Joram#" + AgentServer.getServerId(), this.getMBeanName());
        }
        catch (Exception exc) {
            JoramTracing.dbgProxy.log(BasicLevel.ERROR, (Object)(this + " jmx failed"), (Throwable)exc);
        }
    }

    public void agentFinalize(boolean lastTime) {
        block2: {
            try {
                MXWrapper.unregisterMBean("Joram#" + AgentServer.getServerId(), this.getMBeanName());
            }
            catch (Exception exc) {
                if (!JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        super.agentFinalize(lastTime);
    }

    private String getMBeanName() {
        return "type=User" + ",name=" + (this.name == "" ? this.getId().toString() : this.name);
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent.react(" + from + ',' + not + ')'));
        }
        this.setNoSave();
        if (not instanceof OpenConnectionNot) {
            this.doReact((OpenConnectionNot)not);
        } else if (not instanceof GetConnectionNot) {
            this.doReact((GetConnectionNot)not);
        } else if (not instanceof CloseConnectionNot) {
            this.doReact((CloseConnectionNot)not);
        } else if (not instanceof ResetCollocatedConnectionsNot) {
            this.doReact((ResetCollocatedConnectionsNot)not);
        } else if (not instanceof SendReplyNot) {
            this.doReact((SendReplyNot)not);
        } else if (not instanceof RequestNot) {
            this.doReact((RequestNot)not);
        } else if (not instanceof ReturnConnectionNot) {
            this.doReact((ReturnConnectionNot)not);
        } else if (not instanceof SendRepliesNot) {
            this.doReact((SendRepliesNot)not);
        } else if (not instanceof ProxyRequestGroupNot) {
            this.doReact((ProxyRequestGroupNot)not);
        } else if (not instanceof WakeUpNot) {
            block26: {
                try {
                    this.proxyImpl.cleanPendingMessages(System.currentTimeMillis());
                }
                catch (Exception exc) {
                    if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block26;
                    JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)("--- " + this + " Proxy(...)"), (Throwable)exc);
                }
            }
            if (this.cleaningTask == null) {
                this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class);
            }
            this.cleaningTask.schedule(this.proxyImpl.getPeriod());
        } else {
            try {
                this.proxyImpl.react(from, not);
            }
            catch (UnknownNotificationException exc) {
                super.react(from, not);
            }
        }
    }

    private void doReact(OpenConnectionNot not) {
        ConnectionContext ctx;
        this.setSave();
        if (this.connections == null) {
            this.connections = new Hashtable();
            this.heartBeatTasks = new Hashtable();
        }
        Integer objKey = new Integer(this.keyCounter);
        if (not.getReliable()) {
            ctx = new ReliableConnectionContext(this.proxyImpl, this.keyCounter, not.getHeartBeat());
            this.connections.put(objKey, ctx);
        } else {
            ctx = new StandardConnectionContext(this.proxyImpl, this.keyCounter);
            this.connections.put(objKey, ctx);
        }
        if (not.getHeartBeat() > 0) {
            HeartBeatTask heartBeatTask = new HeartBeatTask(2 * not.getHeartBeat(), objKey);
            this.heartBeatTasks.put(objKey, heartBeatTask);
            heartBeatTask.start();
        }
        this.sendTo(this.getId(), (Notification)new ReturnConnectionNot(not, ctx));
        ++this.keyCounter;
    }

    private void doReact(ReturnConnectionNot not) {
        not.Return();
    }

    private void doReact(GetConnectionNot not) {
        int key = not.getKey();
        if (this.connections == null) {
            not.Throw(new Exception("Connection " + key + " not found"));
        } else {
            Integer objKey = new Integer(key);
            ReliableConnectionContext ctx = (ReliableConnectionContext)this.connections.get(objKey);
            if (ctx == null) {
                not.Throw(new Exception("Connection " + key + " not found"));
            } else {
                not.Return(ctx);
            }
        }
    }

    private void doReact(RequestNot not) {
        ConnectionContext ctx;
        Integer key = new Integer(not.getConnectionKey());
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(key)) != null) {
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            AbstractJmsRequest request = ctx.getRequest(not.getMessage());
            this.proxyImpl.reactToClientRequest((int)key, request);
            if (ctx.isClosed()) {
                this.connections.remove(key);
                HeartBeatTask hbt = (HeartBeatTask)this.heartBeatTasks.remove(key);
                if (hbt != null) {
                    hbt.cancel();
                }
            }
        }
    }

    private void doReact(ProxyRequestGroupNot not) {
        RequestNot[] requests = not.getRequests();
        RequestBuffer rm = new RequestBuffer(this);
        for (int i = 0; i < requests.length; ++i) {
            ConnectionContext ctx;
            RequestNot req = requests[i];
            Integer key = new Integer(req.getConnectionKey());
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            if ((ctx = (ConnectionContext)this.connections.get(key)) == null) continue;
            AbstractJmsRequest request = ctx.getRequest(req.getMessage());
            if (request instanceof ProducerMessages) {
                ProducerMessages pm = (ProducerMessages)request;
                rm.put(req.getConnectionKey(), pm);
                continue;
            }
            if (request instanceof JmsRequestGroup) {
                JmsRequestGroup jrg = (JmsRequestGroup)request;
                AbstractJmsRequest[] groupedRequests = jrg.getRequests();
                for (int j = 0; j < groupedRequests.length; ++j) {
                    if (groupedRequests[i] instanceof ProducerMessages) {
                        ProducerMessages pm = (ProducerMessages)groupedRequests[i];
                        rm.put(req.getConnectionKey(), pm);
                        continue;
                    }
                    this.proxyImpl.reactToClientRequest((int)key, groupedRequests[i]);
                }
                continue;
            }
            this.proxyImpl.reactToClientRequest((int)key, request);
        }
        rm.flush();
    }

    private void doReact(CloseConnectionNot not) {
        Integer key;
        if (this.connections != null && this.connections.remove(key = new Integer(not.getKey())) != null) {
            this.proxyImpl.reactToClientRequest(not.getKey(), new CnxCloseRequest());
            this.heartBeatTasks.remove(key);
        }
    }

    private void doReact(ResetCollocatedConnectionsNot not) {
        if (this.connections != null) {
            Collection values = this.connections.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof StandardConnectionContext)) continue;
                ConnectionContext cc = (ConnectionContext)obj;
                this.proxyImpl.reactToClientRequest(cc.getKey(), new CnxCloseRequest());
                iterator.remove();
            }
        }
    }

    private void doReact(SendRepliesNot not) {
        Enumeration en = not.getReplies();
        while (en.hasMoreElements()) {
            SendReplyNot sr = (SendReplyNot)en.nextElement();
            this.doReact(sr);
        }
    }

    private void doReact(SendReplyNot not) {
        ClientContext cc;
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + not + ')'));
        }
        if ((cc = this.proxyImpl.getClientContext(not.getKey())) != null) {
            if (cc.setReply(not.getRequestId()) == 0) {
                this.sendToClient(not.getKey(), new ServerReply(not.getRequestId()));
            }
        } else if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent: unknown client context for " + not));
        }
    }

    public void sendNot(AgentId to, Notification not) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent.sendNot(" + to + ',' + not + ')'));
        }
        this.sendTo(to, not);
    }

    public void sendToClient(int key, AbstractJmsReply reply) {
        ConnectionContext ctx;
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("UserAgent.sendToClient(" + key + ',' + reply + ')'));
        }
        Integer objKey = new Integer(key);
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(objKey)) != null) {
            ctx.pushReply(reply);
        }
    }

    public void setNoSave() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"setNoSave()");
        }
        super.setNoSave();
    }

    public void setSave() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"UserAgent.setSave()");
        }
        super.setSave();
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.connections = (Hashtable)in.readObject();
        this.heartBeatTasks = (Hashtable)in.readObject();
        if (this.heartBeatTasks != null) {
            Enumeration tasks = this.heartBeatTasks.elements();
            while (tasks.hasMoreElements()) {
                HeartBeatTask task = (HeartBeatTask)tasks.nextElement();
                task.start();
            }
        }
        this.proxyImpl.readBag(in);
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeObject(this.connections);
        out.writeObject(this.heartBeatTasks);
        this.proxyImpl.writeBag(out);
    }

    class HeartBeatTask
    extends TimerTask
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int timeout;
        private Integer key;
        private long lastRequestDate;

        HeartBeatTask(int timeout, Integer key) {
            this.timeout = timeout;
            this.key = key;
        }

        public void run() {
            long date = System.currentTimeMillis();
            if (date - this.lastRequestDate > (long)this.timeout) {
                if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"HeartBeatTask: close connection");
                }
                ConnectionContext ctx = (ConnectionContext)UserAgent.this.connections.remove(this.key);
                UserAgent.this.heartBeatTasks.remove(this.key);
                UserAgent.this.proxyImpl.reactToClientRequest((int)this.key, new CnxCloseRequest());
                MomException exc = new MomException(99999, "Connection " + UserAgent.this.getId() + ':' + this.key + " closed");
                ctx.pushError(exc);
            } else {
                this.start();
            }
        }

        public void start() {
            try {
                AgentServer.getTimer().schedule(this, this.timeout);
            }
            catch (Exception exc) {
                throw new Error(exc.toString());
            }
        }

        public void touch() {
            this.lastRequestDate = System.currentTimeMillis();
        }
    }
}

