/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PStateGraph;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.lib.BasicPNamingContext;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.cache.api.FixableCacheEntry;

public abstract class BasicPBinder
extends BasicPNamingContext
implements PBinder {
    protected CacheManager cache;
    protected PClassMapping pcm;
    protected PName nullPName;

    public BasicPBinder() {
    }

    public BasicPBinder(PClassMapping _pcm) {
        this.pcm = _pcm;
    }

    public BasicPBinder(PName nullPName) {
        this.nullPName = nullPName;
    }

    public String getClassName() {
        return this.ptype.getJormName();
    }

    public PBinding lookup(PName pn) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (pn.isNull()) {
            return null;
        }
        if (this.cache == null) {
            throw new PExceptionProtocol("No internal cache: should be managed externally!");
        }
        CacheEntry ce = this.cache.lookup(pn);
        return ce == null ? null : (PBinding)ce.getCeObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(PName pn, PBindingCtrl pb) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (pb == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is null");
        }
        if (!pn.getClass().equals(this.getNull().getClass())) {
            throw new PExceptionNaming("Can only bind " + this.getNull().getClass() + ", found: " + pn);
        }
        if (!pn.getPNameManager().equals(this)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is not valid in this binder (" + ", \nthis:" + this + ", \nthis.type:" + this.getPType().getJormName() + ", \nthis.pcm:" + this.getBinderClassMapping() + ", \npn.pnc: " + pn.getPNameManager() + ", \npn.pnc.type: " + pn.getPNameManager().getPType().getJormName() + ", \npn.pnc.pcm: " + ((PBinder)pn.getPNameManager()).getBinderClassMapping() + ", \npn:" + pn + ")");
        }
        if (!pb.getPClassMapping().equals(this.pcm)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is not valid in this binder");
        }
        if (pn.isNull()) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this PName represent the null value");
        }
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)1);
        if (this.cache != null) {
            CacheManager cacheManager = this.cache;
            synchronized (cacheManager) {
                try {
                    this.cache.fix(this.cache.bind(pn, pb));
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(pn);
        pb.setStatus(nextstate);
    }

    public PClassMapping getBinderClassMapping() {
        return this.pcm;
    }

    public void setPClassMapping(PClassMapping pcm) {
        this.pcm = pcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(PBindingCtrl pb) throws PException {
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)2);
        if (nextstate == pb.getStatus()) {
            return;
        }
        if (pb == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is null");
        }
        PName pn = pb.getPName();
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this PBinding is not bounded with a pname");
        }
        if (!pb.getPClassMapping().equals(this.pcm)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is not valid in this binder");
        }
        if (this.cache != null) {
            CacheManager cacheManager = this.cache;
            synchronized (cacheManager) {
                try {
                    if (((FixableCacheEntry)((Object)this.cache)).getCeFixCount() == 0) {
                        pb.setPName(null);
                        pb.setStatus(nextstate);
                    } else {
                        CacheEntry ce = this.cache.lookup(pn);
                        if (ce != null) {
                            this.cache.unfix(ce);
                        }
                    }
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(null);
        pb.setStatus(nextstate);
    }

    public CacheManager getCacheManager() {
        return this.cache;
    }

    public void setCacheManager(CacheManager cm) throws PException {
        this.cache = cm;
    }

    public PName getNull() {
        return this.nullPName;
    }

    public void setNullPName(Object o) throws PException {
    }
}

