/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PNameGetter;
import org.objectweb.jorm.naming.api.PNameGetterConverter;

public class SimplePNGConverter
implements PNameGetterConverter {
    public PNameGetter convert(PNameGetter png) throws PExceptionNaming {
        return png;
    }

    public PNameGetter convert(Object o) throws PExceptionNaming {
        return new MyPNG(o);
    }

    public PNameGetter convert(byte o) throws PExceptionNaming {
        return new MyPNG(new Byte(o));
    }

    public PNameGetter convert(char o) throws PExceptionNaming {
        return new MyPNG(new Character(o));
    }

    public PNameGetter convert(short o) throws PExceptionNaming {
        return new MyPNG(new Short(o));
    }

    public PNameGetter convert(int o) throws PExceptionNaming {
        return new MyPNG(new Integer(o));
    }

    public PNameGetter convert(long o) throws PExceptionNaming {
        return new MyPNG(new Long(o));
    }

    private class MyPNG
    implements PNameGetter {
        Object value;

        public MyPNG(Object o) {
            this.value = o;
        }

        public byte pngetByteField(String fn, Object ctxt) throws PException {
            return (Byte)this.value;
        }

        public Byte pngetObyteField(String fn, Object ctxt) throws PException {
            return (Byte)this.value;
        }

        public char pngetCharField(String fn, Object ctxt) throws PException {
            return ((Character)this.value).charValue();
        }

        public Character pngetOcharField(String fn, Object ctxt) throws PException {
            return (Character)this.value;
        }

        public short pngetShortField(String fn, Object ctxt) throws PException {
            return (Short)this.value;
        }

        public Short pngetOshortField(String fn, Object ctxt) throws PException {
            return (Short)this.value;
        }

        public int pngetIntField(String fn, Object ctxt) throws PException {
            return (Integer)this.value;
        }

        public Integer pngetOintField(String fn, Object ctxt) throws PException {
            return (Integer)this.value;
        }

        public long pngetLongField(String fn, Object ctxt) throws PException {
            return (Long)this.value;
        }

        public Long pngetOlongField(String fn, Object ctxt) throws PException {
            return (Long)this.value;
        }

        public String pngetStringField(String fn, Object ctxt) throws PException {
            return (String)this.value;
        }

        public byte[] pngetByteArrayField(String fn, Object ctxt) throws PException {
            return (byte[])this.value;
        }

        public char[] pngetCharArrayField(String fn, Object ctxt) throws PException {
            return (char[])this.value;
        }

        public Date pngetDateField(String fn, Object ctxt) throws PException {
            return (Date)this.value;
        }

        public BigInteger pngetBigIntegerField(String fn, Object ctxt) throws PException {
            return (BigInteger)this.value;
        }

        public BigDecimal pngetBigDecimalField(String fn, Object ctxt) throws PException {
            return (BigDecimal)this.value;
        }
    }
}

