/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.jta.rmi;

import java.io.IOException;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.jta.rmi.JTATransactionServiceContext;
import org.ow2.carol.rmi.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.interceptor.spi.JServerRequestInterceptor;

public class JTAServerTransactionInterceptor
implements JServerRequestInterceptor {
    public static int TX_CTX_ID = 0;
    private static Current current = null;
    private static String interceptorName = "JTAServerTransactionInterceptor";

    public JTAServerTransactionInterceptor() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("JTAServerTransactionInterceptor constructor");
        }
    }

    public void receiveRequest(JServerRequestInfo jri) throws IOException {
        JTATransactionServiceContext jtasc;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("JTAServerTransactionInterceptor.receive_request");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (jtasc = (JTATransactionServiceContext)jri.getRequestServiceContext(TX_CTX_ID)) != null) {
            current.setPropagationContext(jtasc.getTransactionContext(), false);
        }
    }

    public void sendReply(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("JTAServerTransactionInterceptor.send_reply");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.addReplyServiceContext(jtasc);
            current.setPropagationContext(null, false);
        }
    }

    public String name() {
        return interceptorName;
    }

    public void sendException(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("JTAServerTransactionInterceptor.sendException");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.addReplyServiceContext(jtasc);
            current.setPropagationContext(null, false);
        }
    }

    public void sendOther(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("JTAServerTransactionInterceptor.sendOther");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.addReplyServiceContext(jtasc);
            current.setPropagationContext(null, false);
        }
    }
}

