/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XidImpl;
import org.objectweb.jotm.abortXAResourceXid;
import org.objectweb.jotm.commitXAResourceXid;

class processResourceManager
extends Thread {
    private ThreadGroup xaResourceThreadGroup = null;
    Vector txrecovered = null;
    Vector rminfo = null;
    Vector rmreg = null;
    int rmsize = 0;
    int rmindex = 0;

    processResourceManager(ThreadGroup prmThreadGroup, Vector pvtxrecovered, Vector prminfo, Vector prmreg, int prmsize, int prmindex) {
        this.xaResourceThreadGroup = new ThreadGroup(prmThreadGroup, "XAResourceTG");
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("new processResourceManager");
        }
        this.txrecovered = pvtxrecovered;
        this.rminfo = prminfo;
        this.rmreg = prmreg;
        this.rmsize = prmsize;
        this.rmindex = prmindex;
    }

    public void run() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("thread for processResourceManager");
        }
        XAResource myregxares = null;
        RecoverRmInfo myrecoverRmInfo = null;
        String myrm = null;
        String myregrm = null;
        byte[] byxares = null;
        RmRegistration myrmreg = (RmRegistration)this.rmreg.elementAt(this.rmindex);
        myregrm = myrmreg.rmGetName();
        for (int j = 0; j < this.rmsize; ++j) {
            myrecoverRmInfo = (RecoverRmInfo)this.rminfo.elementAt(j);
            myrm = myrecoverRmInfo.getRecoverRm();
            byxares = myrecoverRmInfo.getRecoverXaRes();
            if (!myregrm.equals(myrm)) continue;
            try {
                myregxares = myrmreg.rmCheckoutXARes();
            }
            catch (XAException e) {
                TraceTm.recovery.error("rmCheckoutXARes call failed during recovery " + e.getMessage());
                myrmreg.rmCheckinXARes();
                break;
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Registered Resource Manager " + myregrm);
                TraceTm.recovery.debug("Registered XAResource " + myregxares);
                TraceTm.recovery.debug("Recover Resource Manager " + myrm);
                TraceTm.recovery.debug("Recover XAResource " + new String(byxares));
            }
            LinkedList<Xid> recoveredXidList = new LinkedList<Xid>();
            try {
                Xid[] javaxids;
                boolean first = true;
                while ((javaxids = myregxares.recover(first ? 0x1000000 : 0)) != null && javaxids.length != 0) {
                    first = false;
                    recoveredXidList.addAll(Arrays.asList(javaxids));
                }
            }
            catch (XAException e) {
                TraceTm.recovery.error("xaResource.recover call failed during recovery " + e.getMessage());
                myrmreg.rmCheckinXARes();
                break;
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("recoveredXidList size= " + recoveredXidList.size());
            }
            if (recoveredXidList.size() == 0) {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("No XIDs to recover for Xares= " + myregxares);
                }
                myrmreg.rmCheckinXARes();
                break;
            }
            this.settxxidrecoveraction(myregxares, recoveredXidList);
            this.doActionXidRecover();
            for (int w = 0; w < 10; ++w) {
                boolean xaresinthread = false;
                int numthreads = this.xaResourceThreadGroup.activeCount();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("xaResource active count= " + numthreads);
                }
                if (numthreads == 0) break;
                Thread[] listOfThreads = new Thread[numthreads];
                this.xaResourceThreadGroup.enumerate(listOfThreads);
                for (int i = 0; i < numthreads; ++i) {
                    if (listOfThreads[i] == null) continue;
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug("xaResource in thread= " + listOfThreads[i].getName());
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    xaresinthread = true;
                    break;
                }
                if (!xaresinthread) break;
            }
            myrmreg.rmCheckinXARes();
            break;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("endthread for processResourceManager");
        }
    }

    private void settxxidrecoveraction(XAResource actxares, List actionxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("settxxidrecoveraction");
        }
        TxxidRecovered mytxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        Iterator iter = actionxid.iterator();
        while (iter.hasNext()) {
            boolean xidfound = false;
            Xid myjavaxid = (Xid)iter.next();
            XidImpl myxid = new XidImpl(myjavaxid);
            byte[] mybrqu = myxid.getBranchQualifier();
            for (int j = 0; j < this.txrecovered.size(); ++j) {
                mytxRecovered = (TxRecovered)this.txrecovered.elementAt(j);
                if (mytxRecovered != null) {
                    for (int k = 0; k < mytxRecovered.getxidcount(); ++k) {
                        mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(k);
                        if (mytxxidRecovered == null) continue;
                        byte[] mytxxid = mytxxidRecovered.getRecoverxid();
                        XidImpl mymytxxid = new XidImpl(mytxxid);
                        if (mymytxxid.isThisOneOfOurs(mybrqu)) {
                            if (TraceTm.recovery.isDebugEnabled()) {
                                TraceTm.recovery.debug("mymytxxid= " + mymytxxid.toString(true));
                                TraceTm.recovery.debug("myxid  = " + myxid.toString(true));
                            }
                            if (!new String(mytxxid).equals(myxid.toString(true))) continue;
                            xidfound = true;
                            int myaction = 1;
                            mytxxidRecovered.setRecoveraction(myaction);
                            mytxxidRecovered.setCommitxares(actxares);
                            mytxxidRecovered.setCommitxid(myjavaxid);
                            mytxRecovered.setRecoverTxXidInfo(mytxxidRecovered, k);
                            break;
                        }
                        if (!TraceTm.recovery.isDebugEnabled()) continue;
                        TraceTm.recovery.debug("Xid is not one of ours");
                    }
                }
                if (xidfound) break;
            }
            if (xidfound) continue;
            this.abortimmediate(actxares, myjavaxid);
        }
    }

    private void doActionXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("doActionXidRecover");
        }
        TxxidRecovered mytxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        for (int i = 0; i < this.txrecovered.size(); ++i) {
            mytxRecovered = (TxRecovered)this.txrecovered.elementAt(i);
            XAResource commitxares = null;
            Xid commitxid = null;
            for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (mytxxidRecovered == null || mytxxidRecovered.getRecoveraction() != 1) continue;
                byte[] myrcxid = mytxxidRecovered.getRecoverxid();
                commitxares = mytxxidRecovered.getCommitxares();
                commitxid = mytxxidRecovered.getCommitxid();
                commitXAResourceXid committhread = new commitXAResourceXid(commitxares, commitxid);
                Thread commitxa = new Thread(this.xaResourceThreadGroup, committhread, "commitxid");
                commitxa.start();
            }
        }
    }

    private void abortimmediate(XAResource abortxares, Xid abortxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("abortimmediate");
        }
        abortXAResourceXid abortthread = new abortXAResourceXid(abortxares, abortxid);
        Thread abortxa = new Thread(this.xaResourceThreadGroup, abortthread, "abortxid");
        abortxa.start();
    }
}

