/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.cache.lib;

import java.util.Hashtable;
import java.util.Iterator;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.cache.api.CollectionCache;
import org.objectweb.medor.tuple.api.Tuple;

public class TupleCache
implements CollectionCache {
    private long capacity;
    private int smallIndex = 1;
    private boolean canInsert = true;
    private Hashtable cache;

    public TupleCache(long size) {
        this.capacity = size;
        this.cache = new Hashtable();
    }

    public synchronized long getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized Tuple getTuple(int index) throws MedorException {
        Tuple t = null;
        if (this.cache.containsKey(new Integer(index))) {
            t = (Tuple)this.cache.get(new Integer(index));
        }
        return t;
    }

    public synchronized boolean putTuple(int index, Tuple t) throws MedorException {
        boolean isPuted = false;
        if (this.canInsert && !this.cache.containsKey(new Integer(index))) {
            if ((long)this.cache.size() >= this.capacity) {
                this.cache.remove(new Integer(this.smallIndex));
                ++this.smallIndex;
            }
            this.cache.put(new Integer(index), t);
            isPuted = true;
        }
        return isPuted;
    }

    public synchronized void initialize() {
    }

    public synchronized Iterator tupleIndexIterator() {
        return this.cache.keySet().iterator();
    }

    public synchronized void destroy() {
        this.cache.clear();
    }

    public synchronized boolean contains(int index) {
        return this.cache.containsKey(new Integer(index));
    }

    public boolean isCanInsert() {
        return this.canInsert;
    }

    public void setCanInsert(boolean canInsert) {
        this.canInsert = canInsert;
    }
}

