/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.objectweb.medor.api.EvaluationException;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.Wrapper;
import org.objectweb.medor.eval.api.ConnectionResources;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.api.NodeEvaluatorFactory;
import org.objectweb.medor.eval.lib.AbstractQueryEvaluator;
import org.objectweb.medor.eval.lib.IteratifNodeEvaluatorFactory;
import org.objectweb.medor.eval.lib.MedorConnectionResources;
import org.objectweb.medor.eval.lib.TupleCollectionNodeEvaluator;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.rdb.lib.AggregateRdbQueryNode;
import org.objectweb.medor.tuple.api.TupleCollection;

public class SelectEvaluator
extends AbstractQueryEvaluator {
    protected NodeEvaluatorFactory nodeEvaluatorFactory;
    protected Stack queryTreeStack = new Stack();
    protected long cacheSize;

    public SelectEvaluator(QueryTree query, long cacheSize) throws EvaluationException {
        super(query);
        this.cacheSize = cacheSize;
        this.nodeEvaluatorFactory = new IteratifNodeEvaluatorFactory();
        this.toStack(query, this.queryTreeStack);
    }

    protected void toStack(QueryTree qt, Stack pile) throws EvaluationException {
        pile.push(qt);
        if (qt instanceof QueryNode && !(qt instanceof AggregateRdbQueryNode)) {
            QueryTree[] children = ((QueryNode)qt).getChildren();
            for (int i = children.length - 1; i >= 0; --i) {
                this.toStack(children[i], pile);
            }
        }
    }

    public ConnectionResources getRequiredConnectionResources() {
        HashMap qls = new HashMap(1);
        int size = this.queryTreeStack.size();
        for (int i = 0; i < size; ++i) {
            if (!(this.queryTreeStack.elementAt(i) instanceof QueryLeaf)) continue;
            qls.put(this.queryTreeStack.elementAt(i), null);
        }
        return new MedorConnectionResources(qls);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public TupleCollection evaluate(ParameterOperand[] parameters, ConnectionResources resources, Map evaluationMDMap) throws EvaluationException {
        return this.evaluate(parameters, resources, null, evaluationMDMap);
    }

    public TupleCollection evaluate(ParameterOperand[] parameters, ConnectionResources resources, PrefetchBuffer prefetchBuffer, Map evalMDMap) throws EvaluationException {
        try {
            Stack<NodeEvaluator> runTimeStack = new Stack<NodeEvaluator>();
            for (int cpt = this.queryTreeStack.size() - 1; cpt >= 0; --cpt) {
                EvaluationMetaData emd;
                Object queryTree = this.queryTreeStack.elementAt(cpt);
                EvaluationMetaData evaluationMetaData = emd = evalMDMap != null ? (EvaluationMetaData)evalMDMap.get(queryTree) : null;
                if (queryTree instanceof QueryLeaf) {
                    QueryLeaf ql = (QueryLeaf)queryTree;
                    Wrapper w = this.wrapperFactory.getWrapper(ql.getDataStore());
                    Object conn = resources != null ? resources.getConnection(ql) : null;
                    TupleCollection tc = w.fetchData(ql, parameters, conn, emd);
                    runTimeStack.push(new TupleCollectionNodeEvaluator(tc));
                    continue;
                }
                QueryNode qn = (QueryNode)queryTree;
                QueryTree[] children = qn.getChildren();
                NodeEvaluator[] evals = new NodeEvaluator[children.length];
                for (int i = children.length - 1; i > -1; --i) {
                    evals[i] = (NodeEvaluator)runTimeStack.pop();
                    evals[i].setCacheSize(this.cacheSize);
                }
                runTimeStack.push(this.nodeEvaluatorFactory.createNodeEvaluator(qn, evals, emd));
            }
            NodeEvaluator queryTreeHead = (NodeEvaluator)runTimeStack.pop();
            queryTreeHead.setCacheSize(this.cacheSize);
            queryTreeHead.setPrefetchBuffer(prefetchBuffer);
            return queryTreeHead.fetchData(parameters);
        }
        catch (MedorException mexp) {
            throw new EvaluationException(mexp);
        }
    }
}

