/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends SAMLObject
implements Cloneable {
    private static Hashtable attributeMap = new Hashtable();
    protected String name = null;
    protected String namespace = null;
    protected QName type = null;
    protected long lifetime = 0L;
    protected ArrayList values = new ArrayList();

    public static void regFactory(String string, String string2, String string3) {
        attributeMap.put(string2 + "!!" + string, string3);
    }

    public static void unregFactory(String string, String string2) {
        attributeMap.remove(string2 + "!!" + string);
    }

    public static SAMLAttribute getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() given an empty DOM");
        }
        String string = element.getAttributeNS(null, "AttributeName");
        String string2 = element.getAttributeNS(null, "AttributeNamespace");
        if (string == null || string2 == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() can't find AttributeName or Namespace on root element");
        }
        String string3 = (String)attributeMap.get(string2 + "!!" + string);
        if (string3 == null) {
            return new SAMLAttribute(element);
        }
        try {
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Element")};
            Object[] objectArray = new Object[]{element};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLAttribute)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to locate implementation class for attribute", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to bind to constructor for attribute", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to build implementation object for attribute", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to access implementation of attribute", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() caught unknown exception while building attribute object: " + throwable.getMessage());
        }
    }

    public static SAMLAttribute getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLAttribute.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            NDC.push((String)"SAMLAttribute");
            Category.getInstance((String)"getInstance").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            NDC.push((String)"SAMLAttribute");
            Category.getInstance((String)"getInstance").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }

    protected String computeTypeDecl(Element element) {
        String string = null;
        element.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens");
        if (this.type != null) {
            String string2;
            if ("http://www.w3.org/2001/XMLSchema".equals(this.type.getNamespaceURI())) {
                string2 = "xsd";
            } else {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens", this.type.getNamespaceURI());
                string2 = "typens";
            }
            string = string2 + ":" + this.type.getLocalName();
        }
        return string;
    }

    protected void valueToDOM(Object object, Element element) throws SAMLException {
        element.appendChild(element.getOwnerDocument().createTextNode(object.toString()));
    }

    public SAMLAttribute() {
    }

    public SAMLAttribute(String string, String string2, QName qName, long l, Collection collection) throws SAMLException {
        this.name = string;
        this.namespace = string2;
        this.type = qName;
        this.lifetime = l;
        if (collection != null) {
            this.values.addAll(collection);
        }
    }

    public SAMLAttribute(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttribute(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttribute.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute")) {
            throw new MalformedException("SAMLAttribute.fromDOM() requires saml:Attribute at root");
        }
        this.name = element.getAttributeNS(null, "AttributeName");
        this.namespace = element.getAttributeNS(null, "AttributeNamespace");
        Element element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
        while (element2 != null) {
            if (this.type == null) {
                this.type = QName.getQNameAttribute(element2, "http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            if (this.accept(element2)) {
                this.addValue(element2);
            }
            element2 = XML.getNextSiblingElement(element2);
        }
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AttributeName").setNodeValue(string);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AttributeNamespace").setNodeValue(string);
        }
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
        if (this.root != null) {
            String string = this.computeTypeDecl((Element)this.root);
            Element element = XML.getFirstChildElement(this.root);
            while (element != null) {
                element.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type");
                if (string != null) {
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", string);
                }
                element = XML.getNextSiblingElement(element);
            }
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public boolean accept(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("e cannot be null");
        }
        return true;
    }

    public boolean addValue(Element element) {
        Node node = element.getFirstChild();
        if (this.accept(element)) {
            if (node != null && node.getNodeType() == 3) {
                this.values.add(node.getNodeValue());
                return true;
            }
            this.log.warn((Object)"rejecting an AttributeValue without a simple, non-empty text node");
        }
        return false;
    }

    public void setValues(Collection collection) throws SAMLException {
        while (this.values.size() > 0) {
            this.removeValue(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addValue(iterator.next());
            }
        }
    }

    public void addValue(Object object) throws SAMLException {
        if (object != null) {
            if (this.root != null) {
                String string = this.computeTypeDecl((Element)this.root);
                Element element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
                if (string != null) {
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", string);
                }
                this.valueToDOM(object, element);
                this.root.appendChild(element);
            }
        } else {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.values.add(object);
    }

    public void removeValue(int n) throws IndexOutOfBoundsException {
        this.values.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root);
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        element.setAttributeNS(null, "AttributeName", this.name);
        element.setAttributeNS(null, "AttributeNamespace", this.namespace);
        String string = this.computeTypeDecl(element);
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
            if (string != null) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", string);
            }
            this.valueToDOM(iterator.next(), element2);
            element.appendChild(element2);
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name) || XML.isEmpty(this.namespace) || this.values.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "Attribute invalid, requires name and namespace, and at least one value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttribute sAMLAttribute = (SAMLAttribute)super.clone();
        sAMLAttribute.values = (ArrayList)this.values.clone();
        return sAMLAttribute;
    }
}

