/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.decision;

import java.io.EOFException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.util.Set;
import javax.ejb.EJBException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.ServiceUnavailableException;
import net.jcip.annotations.Immutable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TRANSIENT;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.pool.NamingPoolException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Immutable
public final class DecisionUtil {
    private static Log logger = LogFactory.getLog(DecisionUtil.class);

    private DecisionUtil() {
    }

    public static boolean mustFailoverOnInvoke(Throwable ex, ClusterViewManager clusterViewManager, LoadBalanceable loadBalanceable) {
        Throwable cause = ex;
        while (cause instanceof UndeclaredThrowableException || cause instanceof InvocationTargetException || cause instanceof IllegalStateException || cause instanceof NamingPoolException) {
            if (cause instanceof UndeclaredThrowableException) {
                cause = ((UndeclaredThrowableException)cause).getUndeclaredThrowable();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
                continue;
            }
            cause = cause.getCause();
        }
        if (cause instanceof EJBException) {
            if (clusterViewManager == null) {
                logger.error("Cannot retrieve the manager of the cluster view to resolve this EJBException: ", cause);
                return false;
            }
            cause = ((EJBException)cause).getCausedByException();
            String objectName = null;
            try {
                objectName = ((CMIReference)loadBalanceable).getObjectName();
                Set<String> applicationExceptionNames = clusterViewManager.getApplicationExceptionNames(objectName);
                if (applicationExceptionNames.contains(cause.getClass().getName())) {
                    return false;
                }
            }
            catch (ObjectNotFoundException e) {
                logger.error("Object name not found: {0}", objectName, e);
            }
            return true;
        }
        if (cause instanceof UnmarshalException && ((cause = cause.getCause()) instanceof EOFException || cause instanceof SocketException)) {
            return true;
        }
        return cause instanceof ConnectException || cause instanceof ConnectIOException || cause instanceof NoSuchObjectException || cause instanceof TRANSIENT || cause instanceof COMM_FAILURE || cause instanceof ServiceUnavailableException || cause instanceof NameNotFoundException || cause instanceof CommunicationException || cause instanceof ServerException;
    }

    public static boolean mustFailoverOnLookup(Throwable ex, ClusterViewManager clusterViewManager, LoadBalanceable loadBalanceable) {
        return DecisionUtil.mustFailoverOnInvoke(ex, clusterViewManager, loadBalanceable);
    }
}

