/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMIInvocationHandlerByPool<T>
extends CMIInvocationHandler<T> {
    private static final long serialVersionUID = 3039160413770104463L;
    private static transient Log logger = LogFactory.getLog(CMIInvocationHandlerByPool.class);

    protected CMIInvocationHandlerByPool(ClusterViewManager clusterViewManager, String objectName, String protocolName, boolean keepCurrentRef, Class<? extends T> itf) {
        super(clusterViewManager, objectName, protocolName, keepCurrentRef, itf);
    }

    @Override
    protected CMIReferenceable<T> getCMIReferenceable(CMIReference cmiReference) throws Exception {
        return this.clusterViewManager.getPool(this.objectName).get(cmiReference);
    }

    @Override
    protected void onExceptionHook(String objectName, CMIReferenceable<T> cmiReferenceable) throws Exception {
        try {
            this.clusterViewManager.getPool(objectName).discard(cmiReferenceable);
        }
        catch (Exception e) {
            logger.debug("Cannot discard the reference {0}", cmiReferenceable, e);
        }
    }

    @Override
    protected void onFinallyHook(String objectName, CMIReferenceable<T> cmiReferenceable) {
        try {
            this.clusterViewManager.getPool(objectName).release(cmiReferenceable);
        }
        catch (Exception e) {
            logger.debug("Cannot release the reference {0}", cmiReferenceable, e);
        }
    }
}

