/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.carol;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.jotm.jta.rmi.JTAInterceptorInitializer;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.carol.Protocol;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.component.util.Property;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.easybeans.security.propagation.rmi.jrmp.interceptors.SecurityInitializer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolComponent
implements RegistryComponent {
    private Log logger = LogFactory.getLog(CarolComponent.class);
    private static final String DEFAULT_PREFIX_PROTOCOL = "rmi";
    private List<Protocol> protocols = new ArrayList<Protocol>();
    private String initialContextFactory = null;
    private List<Property> carolProperties = null;
    private boolean unbindOnStop = false;
    private boolean keepRunning = false;
    private boolean initAlreadyDone = false;

    @Override
    public void init() throws EZBComponentException {
        if (this.initAlreadyDone && this.keepRunning) {
            return;
        }
        if (this.protocols == null || this.protocols.isEmpty()) {
            this.logger.debug("No protocols, use the existing carol configuration", new Object[0]);
            return;
        }
        this.initialContextFactory = System.getProperty("java.naming.factory.initial");
        String lstProtocol = null;
        Properties carolConf = new Properties();
        System.setProperty("carol.server.mode", "true");
        carolConf.setProperty("carol.jvm.rmi.local.registry", "true");
        for (Protocol protocol : this.protocols) {
            String url;
            String protocolName = protocol.getName();
            if (lstProtocol != null) {
                lstProtocol = lstProtocol + ",";
                lstProtocol = lstProtocol + protocolName;
            } else {
                lstProtocol = protocolName;
            }
            if (protocol.getUrl() != null) {
                url = protocol.getUrl();
            } else {
                String host = protocol.getHostname();
                int portNumber = protocol.getPortNumber();
                url = "rmi://" + host + ":" + portNumber;
            }
            carolConf.setProperty("carol." + protocolName + ".url", url);
        }
        carolConf.setProperty("carol.protocols", lstProtocol);
        if (this.carolProperties != null) {
            for (Property property : this.carolProperties) {
                carolConf.setProperty(property.getName(), property.getValue());
            }
        }
        this.logger.debug("carolProps: {0}", carolConf);
        String domainName = null;
        try {
            MBeanServer mBeanServer = MBeanServerHelper.getMBeanServerServer();
            if (mBeanServer != null) {
                domainName = mBeanServer.getDefaultDomain();
            }
        }
        catch (JMXRemoteException e) {
            this.logger.debug("No domain name for JMX", e);
        }
        try {
            ConfigurationRepository.init(carolConf, domainName, "EasyBeans");
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot initialize registry", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", JTAInterceptorInitializer.class);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("iiop", "org.objectweb.jotm.ots.OTSORBInitializer");
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", SecurityInitializer.class);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add Security interceptors", e);
        }
    }

    @Override
    public void start() throws EZBComponentException {
        if (this.initAlreadyDone && this.keepRunning) {
            return;
        }
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.getNameServiceManager().startNS();
            }
            catch (Exception e) {
                throw new EZBComponentException("Cannot start registry", e);
            }
        }
        if (this.keepRunning) {
            this.logger.info("KeepRunning mode enabled", new Object[0]);
        }
        this.initAlreadyDone = true;
    }

    @Override
    public void stop() throws EZBComponentException {
        if (this.keepRunning) {
            return;
        }
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.getNameServiceManager().stopNS();
            }
            catch (Exception e) {
                throw new EZBComponentException("Cannot stop the registry", e);
            }
            NamingEnumeration<NameClassPair> namingEnumeration = null;
            try {
                namingEnumeration = new InitialContext().list("");
            }
            catch (NamingException e) {
                throw new EZBComponentException("Unable to unbind remaining objects in the registry", e);
            }
            ArrayList<String> names = new ArrayList<String>();
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncp = (NameClassPair)namingEnumeration.nextElement();
                String txt = "[Name='" + ncp.getName() + "', class='" + ncp.getClassName() + "']";
                names.add(txt);
                if (!this.unbindOnStop) continue;
                try {
                    new InitialContext().unbind(ncp.getName());
                    this.logger.info("Unbind of " + txt + " done !", new Object[0]);
                }
                catch (NamingException e) {
                    this.logger.error("Unable to unbind the name '" + ncp.getName() + "'", e);
                }
            }
            if (names.size() > 0) {
                this.logger.warn("JNDI Names '" + names + "' are still bound in the RMI registry", new Object[0]);
            }
            if (this.initialContextFactory != null) {
                System.setProperty("java.naming.factory.initial", this.initialContextFactory);
            } else {
                System.getProperties().remove("java.naming.factory.initial");
            }
        }
        this.logger.info("Carol Component Stopped", new Object[0]);
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public String getProviderURL() {
        return org.objectweb.carol.util.configuration.ConfigurationRepository.getCurrentConfiguration().getProviderURL();
    }

    public List<Property> getProperties() {
        return this.carolProperties;
    }

    public void setProperties(List<Property> carolProperties) {
        this.carolProperties = carolProperties;
    }

    public boolean isUnbindOnStop() {
        return this.unbindOnStop;
    }

    public void setUnbindOnStop(boolean unbindOnStop) {
        this.unbindOnStop = unbindOnStop;
    }

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }
}

