/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.cmi;

import java.util.Set;
import org.ow2.cmi.annotation.Cluster;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.LifeCycleCallbackException;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.proxy.reference.RemoteCallRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CmiLifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(CmiLifeCycleCallback.class);

    public void beforeBind(EZBContainerCallbackInfo info, EZBRef reference) throws LifeCycleCallbackException {
        Factory<?, ?> factory;
        if (reference instanceof RemoteCallRef && (factory = reference.getFactory()) instanceof SessionFactory) {
            SessionFactory fact = (SessionFactory)factory;
            Object cluster = fact.getBeanInfo().getCluster();
            Class beanClass = fact.getBeanClass();
            Class<?> itfClass = null;
            if (cluster != null || beanClass.isAnnotationPresent(Cluster.class)) {
                String itfClassname = reference.getItfClassName();
                logger.info("The bean with the jndi name {0} and the interface name {1} is clustered.", reference.getJNDIName(), itfClassname);
                for (Class<?> klass : beanClass.getInterfaces()) {
                    if (!klass.getName().equals(itfClassname)) continue;
                    itfClass = klass;
                }
                if (itfClass == null) {
                    logger.error("Cannot find the interface for name {0}", itfClassname);
                    throw new LifeCycleCallbackException("Cannot find the interface for name " + itfClassname);
                }
                Set<String> applicationExceptionNames = factory.getBeanInfo().getApplicationExceptions().keySet();
                ClusteredObjectInfo infos = null;
                try {
                    infos = cluster != null ? CMIInfoExtractor.extractClusteringInfoFromClusteredObject(cluster, itfClass, beanClass, factory instanceof StatefulSessionFactory, false, applicationExceptionNames) : CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(reference.getJNDIName(), itfClass, beanClass, factory instanceof StatefulSessionFactory, applicationExceptionNames);
                    CMIInfoRepository.addClusteredObjectInfo(reference.getJNDIName(), infos);
                }
                catch (CMIInfoExtractorException e) {
                    logger.error("Cannot extract infos for the class with name {0}", beanClass.getName(), e);
                    throw new LifeCycleCallbackException("Cannot extract infos for the class with name " + beanClass.getName(), e);
                }
            }
        }
    }
}

