/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSLSB;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessSessionFactory
extends SessionFactory<EasyBeansSLSB>
implements PoolFactory<EasyBeansSLSB, Long> {
    public StatelessSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        this.setPool(new JPool<EasyBeansSLSB, Long>(this));
    }

    @Override
    public boolean isMatching(EasyBeansSLSB object, Long clue) {
        return true;
    }

    @Override
    public boolean validate(EasyBeansSLSB object, PoolEntryStatistics stats) {
        return true;
    }

    @Override
    protected Long getId(Long beanId) {
        return null;
    }

    @Override
    protected EasyBeansSLSB getBean(Long beanId) throws IllegalArgumentException {
        try {
            return (EasyBeansSLSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        JEJBResponse ejbResponse = new JEJBResponse();
        EasyBeansSLSB bean = null;
        try {
            bean = this.getBean(null);
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", e));
            return ejbResponse;
        }
        catch (NoSuchEJBException e) {
            ejbResponse.setRPCException(new RPCException("Bean has been removed", e));
            return ejbResponse;
        }
        Method m = this.getHashes().get(localCallRequest.getMethodHash());
        if (m == null) {
            ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
            return ejbResponse;
        }
        Object value = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        String oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
        this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
        try {
            value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException(e));
        }
        catch (IllegalAccessException e) {
            ejbResponse.setRPCException(new RPCException(e));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RPCException rpcException = new RPCException(cause);
            ApplicationException applicationException = this.getBeanInfo().getApplicationExceptions().get(cause.getClass().getName());
            if (applicationException != null) {
                rpcException.setApplicationException();
            }
            ejbResponse.setRPCException(rpcException);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
            this.getOperationStateThreadLocal().set(oldState);
            try {
                this.getPool().release(bean);
            }
            catch (PoolException e) {
                ejbResponse.setRPCException(new RPCException("cannot release bean", e));
            }
        }
        ejbResponse.setValue(value);
        return ejbResponse;
    }

    @Override
    public void remove(EasyBeansSLSB instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTimeout(Timer timer) {
        EasyBeansSLSB bean = null;
        bean = this.getBean(null);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            bean.timeoutCallByEasyBeans(timer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                this.getPool().release(bean);
            }
            catch (PoolException e) {
                throw new EJBException("cannot release bean", e);
            }
        }
    }
}

