/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BusinessMethodResolver {
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONST_INIT = "<init>";
    private static Log logger = LogFactory.getLog(BusinessMethodResolver.class);

    private BusinessMethodResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        BusinessMethodResolver.loop(classAnnotationMetadata, classAnnotationMetadata, new ArrayList<String>());
    }

    private static void loop(EasyBeansEjbJarClassMetadata beanclassAnnotationMetadata, EasyBeansEjbJarClassMetadata visitingclassAnnotationMetadata, List<String> visitedInterfaces) {
        IJRemote remoteInterfaces;
        ArrayList<String> businessInterfaces = new ArrayList<String>();
        businessInterfaces.addAll(Arrays.asList(visitingclassAnnotationMetadata.getInterfaces()));
        IJLocal localInterfaces = beanclassAnnotationMetadata.getLocalInterfaces();
        if (localInterfaces != null) {
            for (String itf : localInterfaces.getInterfaces()) {
                if (businessInterfaces.contains(itf)) continue;
                businessInterfaces.add(itf);
            }
        }
        if ((remoteInterfaces = beanclassAnnotationMetadata.getRemoteInterfaces()) != null) {
            for (String itf : remoteInterfaces.getInterfaces()) {
                if (businessInterfaces.contains(itf)) continue;
                businessInterfaces.add(itf);
            }
        }
        for (String itf : businessInterfaces) {
            if (itf.startsWith("javax/ejb/") || itf.startsWith("java/io/Serializable") || itf.startsWith("java/io/Externalizable") || visitedInterfaces.contains(itf)) continue;
            visitedInterfaces.add(itf);
            EasyBeansEjbJarClassMetadata itfMetadata = (EasyBeansEjbJarClassMetadata)visitingclassAnnotationMetadata.getLinkedClassMetadata(itf);
            if (itfMetadata == null) {
                logger.warn("No class was found for interface {0}.", itf);
                continue;
            }
            for (EasyBeansEjbJarMethodMetadata methodData : itfMetadata.getMethodMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals(CLASS_INIT) || itfMethod.getName().equals(CONST_INIT)) continue;
                EasyBeansEjbJarMethodMetadata beanMethod = (EasyBeansEjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + beanclassAnnotationMetadata.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
            if (itfMetadata.getInterfaces() == null) continue;
            BusinessMethodResolver.loop(beanclassAnnotationMetadata, itfMetadata, visitedInterfaces);
        }
    }
}

