/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jsr77;

import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.easybeans.api.jmx.EZBManagementIdentifier;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSR77ManagementIdentifier<T>
implements EZBManagementIdentifier<T> {
    private static final String DEFAULT_DOMAIN_NAME = "";
    private static Log logger = LogFactory.getLog(JSR77ManagementIdentifier.class);
    private String domainName = null;
    private String serverName = null;

    protected JSR77ManagementIdentifier() {
    }

    protected static String getInheritedPropertiesAsString(ObjectName name) {
        Hashtable table = (Hashtable)name.getKeyPropertyList().clone();
        table.remove("j2eeType");
        table.remove("type");
        table.remove("subtype");
        table.remove("name");
        StringBuffer sb = new StringBuffer();
        Set entries = table.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            sb.append(key + "=" + value + ",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected static String getParentNameProperty(String parentObjectName) {
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(parentObjectName);
        }
        catch (MalformedObjectNameException e) {
            logger.error("Cannot get objectname on {0}", parentObjectName, e);
            return DEFAULT_DOMAIN_NAME;
        }
        catch (NullPointerException e) {
            logger.error("Cannot get objectname on {0}", parentObjectName, e);
            return DEFAULT_DOMAIN_NAME;
        }
        String type = on.getKeyProperty("j2eeType");
        String name = on.getKeyProperty("name");
        return type + "=" + name;
    }

    protected static String getPropertyNameValue(String objectName, String property) {
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            logger.error("Cannot get objectname on {0}", objectName, e);
            return DEFAULT_DOMAIN_NAME;
        }
        catch (NullPointerException e) {
            logger.error("Cannot get objectname on {0}", objectName, e);
            return DEFAULT_DOMAIN_NAME;
        }
        String value = on.getKeyProperty(property);
        return property + "=" + value;
    }

    @Override
    public String getDomain() {
        if (this.domainName == null) {
            return DEFAULT_DOMAIN_NAME;
        }
        return this.domainName;
    }

    @Override
    public void setDomain(String domainName) {
        this.domainName = domainName;
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getTypeName() {
        return "j2eeType";
    }

    @Override
    public String getTypeProperty() {
        return this.getTypeName() + "=" + this.getTypeValue();
    }

    public static final Log getLogger() {
        return logger;
    }

    protected String getJ2EEServerString() {
        return "J2EEServer=" + this.serverName;
    }

    public String shorterName(URL url) {
        int slashPos;
        String shortName;
        int dotPos;
        String urlExternalForm = url.toExternalForm();
        if (urlExternalForm.charAt(urlExternalForm.length() - 1) == '/') {
            urlExternalForm = urlExternalForm.substring(0, urlExternalForm.length() - 1);
        }
        if ((dotPos = (shortName = urlExternalForm.substring((slashPos = urlExternalForm.lastIndexOf(47)) + 1, urlExternalForm.length())).lastIndexOf(46)) != -1) {
            shortName = shortName.substring(0, dotPos);
        }
        return shortName;
    }
}

