/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.binder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.osgi.annotation.BindingMode;
import org.ow2.easybeans.osgi.annotation.Multiplicity;
import org.ow2.easybeans.osgi.annotation.OSGiResource;
import org.ow2.easybeans.osgi.binder.desc.DependencyDescription;
import org.ow2.easybeans.osgi.binder.desc.FieldDependencyDescription;
import org.ow2.easybeans.osgi.binder.desc.MethodsDependencyDescription;
import org.ow2.easybeans.osgi.binder.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesBuilder {
    private final Object instance;
    private final BundleContext context;
    private final List<DependencyDescription> dependencies;

    public DependenciesBuilder(Object instance, BundleContext context) {
        this.instance = instance;
        this.context = context;
        this.dependencies = new ArrayList<DependencyDescription>();
    }

    public List<DependencyDescription> extractDependencies() {
        int i;
        Class<?> type;
        Class<?> processed = type = this.instance.getClass();
        while (!Object.class.equals(processed)) {
            Field[] fields = processed.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(OSGiResource.class)) continue;
                this.processAnnotatedField(field);
            }
            processed = processed.getSuperclass();
        }
        processed = type;
        while (!Object.class.equals(processed)) {
            Method[] methods = processed.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.isAnnotationPresent(OSGiResource.class)) continue;
                this.processAnnotatedMethod(method);
            }
            processed = processed.getSuperclass();
        }
        return this.dependencies;
    }

    private void processAnnotatedMethod(Method method) {
        OSGiResource osgi = method.getAnnotation(OSGiResource.class);
        Class<?> type = null;
        Multiplicity multiplicity = null;
        if (Object.class.equals(osgi.type())) {
            type = ReflectionHelper.findServiceInterface(method);
        } else {
            type = osgi.type();
            multiplicity = osgi.multiplicity();
        }
        if (BundleContext.class.equals(type)) {
            if (Multiplicity.MULTIPLE.equals((Object)osgi.multiplicity())) {
                // empty if block
            }
            ReflectionHelper.invokeMethod(method, this.instance, this.context);
        } else {
            String name = null;
            name = !"".equals(osgi.name()) ? osgi.name() : ReflectionHelper.getNameFromMethod(method);
            DependencyDescription desc = this.findDependency(this.dependencies, name);
            if (desc == null) {
                desc = new MethodsDependencyDescription(name);
                this.dependencies.add(desc);
            }
            if (!(desc instanceof MethodsDependencyDescription)) {
                throw new IllegalStateException("Cannot mix Fields and Method dependencies");
            }
            MethodsDependencyDescription description = (MethodsDependencyDescription)desc;
            switch (osgi.mode()) {
                case BIND: {
                    description.setBindMethod(method);
                    break;
                }
                case UNBIND: {
                    description.setUnbindMethod(method);
                    break;
                }
                case BIND_UNBIND: {
                    description.setBindMethod(method);
                    description.setUnbindMethod(method);
                }
            }
            description.setMultiplicity(multiplicity);
            description.setServiceInterface(type);
            if (!"".equals(osgi.filter())) {
                description.setFilter(osgi.filter());
            }
        }
    }

    private void processAnnotatedField(Field field) {
        OSGiResource osgi = field.getAnnotation(OSGiResource.class);
        if (!BindingMode.BIND_UNBIND.equals((Object)osgi.mode())) {
            throw new IllegalStateException("Invalid BindingMode (" + (Object)((Object)osgi.mode()) + ") on field (" + field.getName() + ")." + " Only BIND_UNBIND is allowed.");
        }
        if (BundleContext.class.equals(field.getType())) {
            if (Multiplicity.MULTIPLE.equals((Object)osgi.multiplicity())) {
                // empty if block
            }
            ReflectionHelper.setFieldValue(this.instance, field, this.context);
        } else {
            Multiplicity multiplicity = null;
            Class<?> type = null;
            String name = field.getName();
            Class<?> fieldType = field.getType();
            if (fieldType.isArray()) {
                multiplicity = Multiplicity.MULTIPLE;
                if (fieldType.getComponentType().isArray()) {
                    throw new IllegalStateException("Illegal dependency (" + name + ") on multiple dimension array (" + fieldType + ")");
                }
                type = fieldType.getComponentType();
            } else if (Collection.class.isAssignableFrom(fieldType)) {
                multiplicity = Multiplicity.MULTIPLE;
                AbstractCollection value = ReflectionHelper.getFieldValue(this.instance, field, Object.class);
                if (value == null) {
                    if (List.class.isAssignableFrom(fieldType)) {
                        value = new ArrayList();
                    } else if (Set.class.isAssignableFrom(fieldType)) {
                        value = new HashSet();
                    } else if (Queue.class.isAssignableFrom(fieldType)) {
                        value = new LinkedList();
                    } else {
                        throw new IllegalStateException("Unmanaged Collection type (" + fieldType + "). Prefer intialization ins constructor.");
                    }
                    ReflectionHelper.setFieldValue(this.instance, field, value);
                }
                if (!Object.class.equals(osgi.type())) {
                    type = osgi.type();
                }
            } else {
                type = fieldType;
                multiplicity = Multiplicity.SINGLE;
            }
            FieldDependencyDescription description = new FieldDependencyDescription(name, field);
            description.setServiceInterface(type);
            description.setMultiplicity(multiplicity);
            if (!"".equals(osgi.filter())) {
                description.setFilter(osgi.filter());
            }
            this.dependencies.add(description);
        }
    }

    private DependencyDescription findDependency(List<DependencyDescription> dependencies, String name) {
        for (DependencyDescription description : dependencies) {
            if (!description.getName().equals(name)) continue;
            return description;
        }
        return null;
    }
}

