/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.rar.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.rar.RarDeploymentDesc;
import org.ow2.jonas.deployment.rar.RarDeploymentDescException;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.Log;

public class RarManagerWrapper {
    private static final String RAR_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.rar.lib.RarDeploymentDescManager";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ear");

    private RarManagerWrapper() {
    }

    public static RarDeploymentDesc getRarDeploymentDesc(String rar, ClassLoader cl) throws DeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        RarDeploymentDesc rarDD = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class<?> manager = ext.loadClass(RAR_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", String.class, ClassLoader.class);
            rarDD = (RarDeploymentDesc)m.invoke(null, rar, cl);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (RarDeploymentDescException.class.isInstance(t)) {
                throw (RarDeploymentDescException)ite.getTargetException();
            }
            throw new RarDeploymentDescException("RarDeploymentDescManager.getInstance fails", t);
        }
        catch (Exception e) {
            throw new RarDeploymentDescException("Problems when using reflection on RarDeploymentDescManager", e);
        }
        return rarDD;
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class<?> manager = ext.loadClass(RAR_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", Boolean.TYPE);
            m.invoke(null, new Boolean(b));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static RarDeploymentDesc getInstance(Context ctx) throws DeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        RarDeploymentDesc rarDD = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class<?> manager = ext.loadClass(RAR_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", Context.class);
            rarDD = (RarDeploymentDesc)m.invoke(null, ctx);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (RarDeploymentDescException.class.isInstance(t)) {
                throw (RarDeploymentDescException)ite.getTargetException();
            }
            throw new RarDeploymentDescException("RarDeploymentDescManager.getInstance fails", t);
        }
        catch (Exception e) {
            throw new RarDeploymentDescException("Problems when using reflection on RarDeploymentDescManager", e);
        }
        return rarDD;
    }
}

