/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.base.DuplicateServerNameException;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.internal.MulticastDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.internal.client.DiscoveryClient;
import org.ow2.jonas.discovery.internal.enroller.Enroller;
import org.ow2.jonas.discovery.internal.manager.DiscoveryManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public class MulticastDiscoveryServiceImpl
extends BaseDiscovery
implements MulticastDiscoveryServiceImplMBean {
    private String listeningIp = null;
    private int listeningPort;
    private int greetingListeningPort;
    private int sourcePort;
    private DiscoveryManager dm = null;
    private Enroller enroller = null;
    private DiscoveryClient dc;
    private static Logger logger = Log.getLogger("org.ow2.jonas.discovery");

    public String getDiscoveryAddress() {
        return this.listeningIp;
    }

    public String getDiscoveryPort() {
        return String.valueOf(this.listeningPort);
    }

    public void setMulticastAddress(String address) {
        this.listeningIp = address;
    }

    public void setMulticastPort(int port) {
        this.listeningPort = port;
    }

    public void startDiscoveryMaster() throws JMException {
        if (!this.getIsDiscoveryMaster()) {
            this.createEnroller(this.getDomainName());
            this.createDiscClient(this.getDomainName());
            this.setMaster(true);
        }
    }

    private void createEnroller(String domainName) throws JMException {
        this.enroller = new Enroller(this.listeningPort, this.listeningIp);
        this.enroller.setTimeToLive(this.getTtl());
        this.getJmxService().registerMBean((Object)this.enroller, JonasObjectName.discoveryEnroller(domainName));
    }

    private void createDiscClient(String domainName) throws JMException {
        this.dc = new DiscoveryClient(this.listeningPort, this.listeningIp, this.sourcePort);
        this.dc.setTimeToLive(this.getTtl());
        this.getJmxService().registerMBean((Object)this.dc, JonasObjectName.discoveryClient(domainName));
    }

    protected void doStart() throws ServiceException {
        JmxService jmx = this.getJmxService();
        this.setMaster(this.getServerProperties().isMaster());
        this.dm = new DiscoveryManager(this.getJonasServerName(), this.listeningPort, this.listeningIp, this.greetingListeningPort, this.getGreetingTimeout());
        String domainName = this.getDomainName();
        this.dm.setDomainName(domainName);
        this.dm.setJonasName(this.getJonasServerName());
        this.dm.setTimeToLive(this.getTtl());
        JMXServiceURL[] connectorServerURLs = jmx.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        this.dm.setUrls(urls);
        try {
            jmx.registerMBean((Object)this.dm, JonasObjectName.discoveryManager(domainName));
        }
        catch (MalformedObjectNameException e1) {
            e1.printStackTrace();
            throw new ServiceException("Problem when starting the Discovery Service:", e1);
        }
        try {
            this.dm.start();
        }
        catch (DuplicateServerNameException e) {
            logger.log(BasicLevel.ERROR, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            try {
                jmx.unregisterMBean(JonasObjectName.discoveryManager(domainName));
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                throw new ServiceException("Problem when starting the Discovery Service:", e1);
            }
            throw new ServiceException("Problem when starting the Discovery Service:", e);
        }
        if (this.getIsDiscoveryMaster()) {
            try {
                this.createEnroller(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", e);
            }
            try {
                this.createDiscClient(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", e);
            }
        }
        jmx.registerMBean((Object)this, JonasObjectName.discoveryService(domainName));
        logger.log(BasicLevel.INFO, (Object)"Multicast discovery started successfully");
    }

    protected void doStop() throws ServiceException {
        JmxService jmxService = this.getJmxService();
        if (jmxService != null) {
            jmxService.unregisterMBean(JonasObjectName.discoveryService(this.getDomainName()));
        }
        logger.log(BasicLevel.INFO, (Object)"Multicast discovery stopped successfully");
    }

    public DiscEvent getDiscEvent(String serverName, String domainName, String[] connectorURLs, String state) {
        String sourceAddress = null;
        int sourcePort = 0;
        String serverId = null;
        DiscEvent fakeMessage = new DiscEvent(sourceAddress, sourcePort, serverName, domainName, serverId, connectorURLs);
        fakeMessage.setState(state);
        return fakeMessage;
    }

    public String getDiscoveryProtocolVersion() {
        return "1.1";
    }

    public String getDiscoveryTtl() {
        return String.valueOf(this.getTtl());
    }

    public ObjectName getDiscoveryClient() {
        return null;
    }

    public ObjectName getDiscoveryManager() throws MalformedObjectNameException {
        return JonasObjectName.discoveryManager(this.getDomainName());
    }

    public ObjectName getEnroller() throws MalformedObjectNameException {
        return JonasObjectName.discoveryEnroller(this.getJmxService().getDomainName());
    }

    public String getListeningIp() {
        return this.listeningIp;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setListeningIp(String listeningIp) {
        this.listeningIp = listeningIp;
    }

    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    public void setSourcePort(int sourcePort) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting source port \n");
        this.sourcePort = sourcePort;
    }

    public void setUrlsList(ArrayList urlsList) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
    }

    public int getGreetingPort() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting greeting listening port \n");
        return this.greetingListeningPort;
    }

    public void setGreetingPort(int port) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting greeting port \n");
        this.greetingListeningPort = port;
    }

    public ArrayList getUrlsList() {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        return this.urlsList;
    }

    public String getJonasName() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting name \n");
        return this.dm.getJonasName();
    }

    public MBeanServer getMbeanServer() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting MBean server \n");
        return this.getJmxService().getJmxServer();
    }

    public ObjectName getMyOn() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting ObjectName \n");
        return JonasObjectName.discoveryService(this.getJmxService().getDomainName());
    }

    public String getServerId() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting server ID \n");
        return this.getJmxService().getJonasServerName();
    }

    public String[] getUrls() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting urls \n");
        return (String[])this.urlsList.toArray();
    }

    public void setDomainName(String domainName) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting domain name \n");
        this.dm.setDomainName(domainName);
    }

    public void setJonasName(String jonasName) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting name \n");
        this.dm.setJonasName(jonasName);
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting MBean server: not yet implemented \n");
    }

    public void setMyOn(ObjectName myOn) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ObjectName: not yet implemented \n");
    }

    public void setServerId(String serverId) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting  server ID: not yet implemented \n");
    }

    public void setUrls(String[] urls) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting server urls \n");
        this.urlsList = this.toArrayList(urls);
    }

    private ArrayList toArrayList(String[] urls) throws NullPointerException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < urls.length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException thrown in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
        }
        return ret;
    }

    public String getMulticastAddress() {
        return this.getListeningIp();
    }

    public String getMulticastPort() {
        return new Integer(this.listeningPort).toString();
    }
}

