/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal;

import org.ow2.jonas.ejb2.EJBService;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB21Deployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(EJB21Deployer.class);
    private EJBService ejb21Service = null;

    @Override
    public void doUndeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info("Undeploying {0}", deployable);
        try {
            this.ejb21Service.removeContainer(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + deployable + "'.", e);
        }
    }

    @Override
    public void doDeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info("Deploying {0}", deployable);
        try {
            this.ejb21Service.createContainer(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + deployable + "'.", e);
        }
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB21Deployable;
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }
}

