/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal.mbean;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.management.javaee.J2EEModule;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.Log;

public class EJBModule
extends J2EEModule {
    protected JContainer cont;
    private ArrayList ejbs = new ArrayList();
    private static Logger logger = Log.getLogger("org.ow2.jonas.ejb");
    String containerName = null;
    String fileName = null;
    private String earON = null;
    private URL earURL = null;
    private boolean inEarCase = false;
    private MBeanServer mBeanServer;
    private ObjectName objectName;

    public EJBModule(MBeanServer mBeanServer, ObjectName objectName, JContainer cont, String fileName, String containerName, String j2eeAppName, URL earUrl) {
        super(objectName.toString());
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        this.cont = cont;
        this.fileName = fileName;
        this.containerName = containerName;
        if (j2eeAppName != null && earUrl != null) {
            ObjectName j2eeAppOn = J2eeObjectName.J2EEApplication(objectName.getDomain(), objectName.getKeyProperty("J2EEServer"), j2eeAppName);
            this.earON = j2eeAppOn.toString();
            this.earURL = earUrl;
            this.inEarCase = true;
        }
    }

    public String[] getEjbs() {
        return this.ejbs.toArray(new String[this.ejbs.size()]);
    }

    public void addEjb(String ejbObjectName) {
        this.ejbs.add(ejbObjectName);
    }

    public int getCurrentNumberOfEJB() {
        return this.ejbs.size();
    }

    public int getCurrentNumberOfBMP() {
        return this.cont.getEntityBMPNb();
    }

    public int getCurrentNumberOfCMP() {
        return this.cont.getEntityCMPNb();
    }

    public int getCurrentNumberOfSBF() {
        return this.cont.getStatefulSessionNb();
    }

    public int getCurrentNumberOfSBL() {
        return this.cont.getStatelessSessionNb();
    }

    public int getCurrentNumberOfMDB() {
        return this.cont.getMessageDrivenNb();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URL getUrl() {
        try {
            return new File(this.fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot get URL for fileName '" + this.fileName + "'.", e);
        }
    }

    public String getEarON() {
        return this.earON;
    }

    public URL getEarURL() {
        return this.earURL;
    }

    public boolean isInEarCase() {
        return this.inEarCase;
    }

    public int getNumberOfCalls() {
        int numberOfCalls = 0;
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                numberOfCalls += ((Integer)this.mBeanServer.getAttribute(on, "numberOfCalls")).intValue();
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                numberOfCalls += ((Integer)this.mBeanServer.getAttribute(on, "numberOfCalls")).intValue();
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'numberOfCalls'", (Throwable)e);
        }
        return numberOfCalls;
    }

    public long getTotalProcessingTime() {
        long totalProcessingTime = 0L;
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                totalProcessingTime += ((Long)this.mBeanServer.getAttribute(on, "totalProcessingTime")).longValue();
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                totalProcessingTime += ((Long)this.mBeanServer.getAttribute(on, "totalProcessingTime")).longValue();
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalProcessingTime'", (Throwable)e);
        }
        return totalProcessingTime;
    }

    public long getTotalBusinessProcessingTime() {
        long totalBusinessProcessingTime = 0L;
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                totalBusinessProcessingTime += ((Long)this.mBeanServer.getAttribute(on, "totalBusinessProcessingTime")).longValue();
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                totalBusinessProcessingTime += ((Long)this.mBeanServer.getAttribute(on, "totalBusinessProcessingTime")).longValue();
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalBusinessProcessingTime'", (Throwable)e);
        }
        return totalBusinessProcessingTime;
    }

    public long getAverageProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    public long getAverageBusinessProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalBusinessProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    public boolean getMonitoringEnabled() {
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                if (((Boolean)this.mBeanServer.getAttribute(on, "monitoringEnabled")).booleanValue()) continue;
                return false;
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                if (((Boolean)this.mBeanServer.getAttribute(on, "monitoringEnabled")).booleanValue()) continue;
                return false;
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'monitoringEnabled'", (Throwable)e);
        }
        return true;
    }

    public void setMonitoringEnabled(boolean monitoringEnabled) {
        Attribute monitoringEnabledAttribute = new Attribute("monitoringEnabled", new Boolean(monitoringEnabled));
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                this.mBeanServer.setAttribute(on, monitoringEnabledAttribute);
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                this.mBeanServer.setAttribute(on, monitoringEnabledAttribute);
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed setting attribute 'monitoringEnabled'", (Throwable)e);
        }
    }

    public int getWarningThreshold() {
        int warningThreshold = -1;
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                int currentWarningThreshold = (Integer)this.mBeanServer.getAttribute(on, "warningThreshold");
                if (warningThreshold == -1) {
                    warningThreshold = currentWarningThreshold;
                    continue;
                }
                if (warningThreshold == currentWarningThreshold) continue;
                return -1;
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                int currentWarningThreshold = (Integer)this.mBeanServer.getAttribute(on, "warningThreshold");
                if (warningThreshold == -1) {
                    warningThreshold = currentWarningThreshold;
                    continue;
                }
                if (warningThreshold == currentWarningThreshold) continue;
                return -1;
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'warningThreshold'", (Throwable)e);
        }
        return warningThreshold;
    }

    public void setWarningThreshold(int warningThreshold) {
        Attribute warningThresholdAttribute = new Attribute("warningThreshold", new Integer(warningThreshold));
        try {
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatefulSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                this.mBeanServer.setAttribute(on, warningThresholdAttribute);
            }
            for (ObjectName on : this.mBeanServer.queryNames(new ObjectName(this.objectName.getDomain() + ":j2eeType=StatelessSessionBean,EJBModule=" + this.containerName + ",*"), null)) {
                this.mBeanServer.setAttribute(on, warningThresholdAttribute);
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed setting attribute 'warningThreshold'", (Throwable)e);
        }
    }
}

