/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.utils.ArchiveStorer;

public class JarStorer
extends ArchiveStorer {
    private JarOutputStream jos;

    public JarStorer(J2EEArchive archive, File jar) throws GenBaseException {
        super(archive);
        this.setOut(jar.getAbsolutePath());
        try {
            if (!jar.getParentFile().exists() && !jar.getParentFile().mkdirs()) {
                String err = JarStorer.getI18n().getMessage("JarStorer.constr.create", jar.getParentFile());
                throw new GenBaseException(err);
            }
            this.jos = new JarOutputStream((OutputStream)new FileOutputStream(jar), archive.getManifest());
        }
        catch (IOException ioe) {
            String err = JarStorer.getI18n().getMessage("JarStorer.constr.ioe", jar);
            throw new GenBaseException(err, ioe);
        }
    }

    protected String convertName(String name) {
        return name.replace('\\', '/');
    }

    protected void addFile(String name) throws IOException {
        ZipEntry ze = new ZipEntry(this.convertName(name));
        this.jos.putNextEntry(ze);
        InputStream is = this.getArchive().getInputStream(name);
        JarStorer.fill(is, this.jos);
        is.close();
    }

    public void store() throws GenBaseException {
        super.store();
        try {
            this.jos.flush();
            this.jos.close();
        }
        catch (IOException ioe) {
            String err = JarStorer.getI18n().getMessage("JarStorer.store.close");
            throw new GenBaseException(err, ioe);
        }
    }

    protected OutputStream getOutputStream(String name) throws IOException {
        ZipEntry ze = new ZipEntry(this.convertName(name));
        this.jos.putNextEntry(ze);
        return this.jos;
    }
}

