/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub;

import java.io.File;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.NoJ2EEWebservicesException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.generator.GeneratorFactories;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.genbase.utils.TempRepository;
import org.ow2.jonas.generators.genclientstub.generator.GeneratorFactory;
import org.ow2.jonas.generators.genclientstub.modifier.ModifierFactory;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStubGen {
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.genclientstub");
    private boolean inputModified = true;

    public static void main(String[] args) throws Exception {
        ClientStubGen stubGen = new ClientStubGen();
        stubGen.execute(args);
    }

    public String execute(String[] args) throws Exception {
        Config config = ClientStubGen.parseInput(args);
        if (config.isHelp() || config.isError() || config.getInputname() == null) {
            ClientStubGen.usage();
            return null;
        }
        return this.execute(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Config config, IDeployable<?> deployable) throws Exception {
        GeneratorFactory gf = GeneratorFactory.getInstance();
        config.setDTDsAllowed(true);
        gf.setConfiguration(config);
        GeneratorFactories.setCurrentFactory(gf);
        Archive modifiedArchive = null;
        ArchiveModifier am = null;
        try {
            String path;
            am = ModifierFactory.getModifier(config.getInputname(), true, deployable);
            logger.log(BasicLevel.INFO, (Object)("Client stub generation for '" + config.getInputname() + "'"));
            modifiedArchive = am.modify();
            String string = path = modifiedArchive.getRootFile().getCanonicalPath();
            return string;
        }
        catch (NoJ2EEWebservicesException e) {
            logger.log(BasicLevel.WARN, (Object)(config.getInputname() + "Error while generating stubs : '" + e.getMessage() + "'"));
            this.inputModified = false;
            String string = config.getInputname();
            return string;
        }
        finally {
            if (am != null && am.getArchive() != null) {
                am.getArchive().close();
            }
            modifiedArchive = null;
            am = null;
            TempRepository.getInstance().deleteAll();
            System.gc();
        }
    }

    private static Config parseInput(String[] args) {
        Config config = new Config();
        for (int argn = 0; argn < args.length; ++argn) {
            String arg = args[argn];
            if (arg.equals("-help") || arg.equals("-?")) {
                config.setHelp(true);
                continue;
            }
            if (arg.equals("-verbose")) {
                config.setVerbose(true);
                continue;
            }
            if (arg.equals("-debug")) {
                config.setDebug(true);
                config.setVerbose(true);
                continue;
            }
            if (arg.equals("-keepgenerated")) {
                config.setKeepGenerated(true);
                continue;
            }
            if (arg.equals("-noconfig")) {
                config.setNoConfig(true);
                continue;
            }
            if (arg.equals("-novalidation")) {
                config.setParseWithValidation(false);
                continue;
            }
            if (arg.equals("-javac")) {
                config.setNameJavac(args[++argn]);
                continue;
            }
            if (arg.equals("-javacopts")) {
                if (++argn < args.length) {
                    StringTokenizer st = new StringTokenizer(args[argn]);
                    while (st.hasMoreTokens()) {
                        config.getJavacOpts().add(st.nextToken());
                    }
                    continue;
                }
                config.setError(true);
                continue;
            }
            if (arg.equals("-d")) {
                if (++argn < args.length) {
                    config.setOut(new File(args[argn]));
                    continue;
                }
                config.setError(true);
                continue;
            }
            if (args[argn] != null) {
                config.setInputname(args[argn]);
                continue;
            }
            config.setError(true);
        }
        return config;
    }

    public static void usage() {
        StringBuffer msg = new StringBuffer();
        msg.append("Usage: java org.ow2.jonas.generators.genclientstub.ClientStubgen -help \n");
        msg.append("   to print this help message \n");
        msg.append(" or java org.ow2.jonas.generators.genclientstub.ClientStubgen <Options> <Input_File> \n");
        msg.append("Options include: \n");
        msg.append("    -d <output_dir>  specify where to place the generated files \n");
        msg.append("    -novalidation parse the XML deployment descriptors without \n");
        msg.append("      validation \n");
        msg.append("    -javac  <opt> specify the java compiler to use \n");
        msg.append("    -javacopts <opt> specify the options to pass to the java compiler \n");
        msg.append("    -keepgenerated   do not delete intermediate generated files \n");
        msg.append("    -noconfig  do not generate configuration files (require \n");
        msg.append("      user provided files) \n");
        msg.append("    -verbose \n");
        msg.append("    -debug \n");
        msg.append(" \n");
        msg.append("    Input_File    the ejb-jar, war or ear filename\n");
        System.out.println(msg.toString());
    }

    public boolean isInputModified() {
        return this.inputModified;
    }
}

