/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.ews;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.constants.Scope;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.generator.WsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.JOnASJ2EEWebServicesContext;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.ServiceReferenceContextImpl;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.emitter.FullEmitter;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.factory.JOnASClientGeneratorFactory;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.wscf.JOnASWSCFHandler;
import org.ow2.jonas.lib.loader.AbsModuleClassLoader;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EWSWsClientGenerator
extends WsClientGenerator {
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.wsgen.ews");
    private static final String CLIENT_CONFIG = "axis.clientConfigFile";
    private File generated = null;
    private static final String WEB_PREFIX = "WEB-INF/";
    private static I18n i18n = I18n.getInstance(EWSWsClientGenerator.class);

    public EWSWsClientGenerator(Config config, ServiceRefDesc srd, WsClientDDModifier ddm, Archive archive) throws GenBaseException {
        super(config, srd, ddm, archive);
    }

    public void generate() throws WsGenException {
        boolean hasWSDL;
        boolean bl = hasWSDL = this.getRef().getWsdlFileName() != null;
        if (hasWSDL) {
            J2EEArchive j2eeArchive = (J2EEArchive)this.getArchive();
            AbsModuleClassLoader cl = (AbsModuleClassLoader)j2eeArchive.getModuleClassloader();
            this.getConfig().setClasspath(this.getConfig().getClasspath() + cl.getClasspath());
            try {
                FullEmitter wsEmitter = new FullEmitter();
                wsEmitter.setMappingFileInputStream(this.getRef().getMappingFileURL().openStream());
                JOnASClientGeneratorFactory factory = new JOnASClientGeneratorFactory();
                factory.setEmitter(wsEmitter);
                wsEmitter.setTypeMappingVersion("1.3");
                wsEmitter.setScope(Scope.REQUEST);
                wsEmitter.setWrapArrays(true);
                wsEmitter.setClassLoader(cl);
                wsEmitter.setFactory(factory);
                wsEmitter.setJOnASWsContext(this.prepareJ2EEWebServicesContext(this.getRef()));
                wsEmitter.setOutputDir(this.getSources().getCanonicalPath());
                wsEmitter.setAllowInvalidURL(true);
                wsEmitter.run(this.getRef().getLocalWSDLURL().toExternalForm());
                this.generated = new File(EWSWsClientGenerator.findClientConfigFile(wsEmitter.getGeneratedFileInfo()));
                EWSWsClientGenerator.getLogger().log(BasicLevel.INFO, (Object)"Web Services Classes successfully generated by EWS.");
                EWSWsClientGenerator.getLogger().log(BasicLevel.INFO, (Object)("Webservice client WSDD file '" + this.generated + "' sucessfully generated by EWS."));
            }
            catch (Exception e) {
                String err = EWSWsClientGenerator.getI18n().getMessage("EWSWsClientGenerator.generate.WSDL2Java", e.getMessage());
                logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
                throw new WsGenException(err, e);
            }
        }
    }

    private static String findClientConfigFile(GeneratedFileInfo generatedFileInfo) {
        List generated = generatedFileInfo.getFileNames();
        boolean found = false;
        String filename = null;
        Iterator i = generated.iterator();
        while (i.hasNext() && !found) {
            String entry = (String)i.next();
            if (!entry.matches(".*deploy-client-\\d+\\.wsdd$")) continue;
            found = true;
            filename = entry;
        }
        return filename;
    }

    private JOnASJ2EEWebServicesContext prepareJ2EEWebServicesContext(ServiceRefDesc ref) {
        JOnASJ2EEWebServicesContext wsCtx = new JOnASJ2EEWebServicesContext();
        ServiceReferenceContextImpl sRefCtx = new ServiceReferenceContextImpl();
        sRefCtx.setServiceQName(ref.getServiceQName());
        for (HandlerDesc handler : ref.getHandlerRefs()) {
            sRefCtx.addHandler(new JOnASWSCFHandler(handler));
        }
        wsCtx.addServiceReferenceContext(sRefCtx);
        return wsCtx;
    }

    public void addFiles(Archive archive) throws WsGenException {
        if (archive instanceof WebApp) {
            WebApp web = (WebApp)archive;
            archive.addDirectoryIn("WEB-INF/classes/", this.getClasses());
            archive.addDirectoryIn("WEB-INF/sources/", this.getSources());
            if (this.generated != null) {
                archive.addFileIn(WEB_PREFIX, this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    boolean jwaFileExists = this.getArchive().getContainedFiles().contains("WEB-INF/jonas-web.xml");
                    boolean jwaDocumentExists = web.getDescriptors().containsKey("WEB-INF/jonas-web.xml");
                    if (!jwaFileExists && !jwaDocumentExists) {
                        this.createEmptyJonasWeb((J2EEArchive)archive);
                    }
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, WEB_PREFIX + this.generated.getName());
            }
        } else if (archive instanceof EjbJar) {
            archive.addDirectory(this.getClasses());
            if (this.generated != null) {
                archive.addFileIn("META-INF/", this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, "META-INF/" + this.generated.getName());
            }
        } else {
            Client client = (Client)archive;
            archive.addDirectory(this.getClasses());
            if (this.generated != null) {
                archive.addFileIn("META-INF/", this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    boolean jcFileExists = this.getArchive().getContainedFiles().contains("META-INF/jonas-client.xml");
                    boolean jcDocumentExists = client.getDescriptors().containsKey("META-INF/jonas-client.xml");
                    if (!jcFileExists && !jcDocumentExists) {
                        this.createEmptyJonasClient((J2EEArchive)archive);
                    }
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, "META-INF/" + this.generated.getName());
            }
        }
    }

    private void createEmptyJonasWeb(J2EEArchive archive) {
        Document doc = XMLUtils.newJonasWeb();
        archive.getDescriptors().put("WEB-INF/jonas-web.xml", doc);
        this.getModifier().setDocument(doc);
    }

    private void createEmptyJonasClient(J2EEArchive archive) {
        Document doc = XMLUtils.newJonasClient();
        archive.getDescriptors().put("META-INF/jonas-client.xml", doc);
        this.getModifier().setDocument(doc);
    }

    public static I18n getI18n() {
        return i18n;
    }
}

