/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.modifier;

import java.io.File;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.JarArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.modifier.AbsModifierFactory;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.modifier.ApplicationModifier;
import org.ow2.jonas.generators.wsgen.modifier.ClientModifier;
import org.ow2.jonas.generators.wsgen.modifier.EjbJarModifier;
import org.ow2.jonas.generators.wsgen.modifier.WebAppModifier;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierFactory
extends AbsModifierFactory {
    private static I18n i18n = I18n.getInstance(ModifierFactory.class);

    private ModifierFactory() {
    }

    public static ArchiveModifier getModifier(String filename) throws GenBaseException {
        return ModifierFactory.getModifier(filename, true, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveModifier getModifier(String filename, boolean init, IDeployable<?> deployable) throws GenBaseException {
        void var5_20;
        void var4_14;
        int mode;
        void var3_6;
        Object var3_3 = null;
        Object var4_9 = null;
        Object var5_15 = null;
        IDeployable<EARDeployable> localDeployable = null;
        File file = new File(filename);
        if (!file.exists()) {
            String err = i18n.getMessage("ModifierFactory.getModifier.notfound", filename);
            throw new WsGenException(err);
        }
        if (file.isFile()) {
            JarArchive jarArchive = new JarArchive(file);
        } else {
            FileArchive fileArchive = new FileArchive(file);
        }
        try {
            if (deployable == null) {
                IArchive fileArchive = ArchiveManager.getInstance().getArchive(file);
                localDeployable = DeployableHelper.getDeployable(fileArchive);
            } else {
                localDeployable = deployable;
            }
        }
        catch (Exception e) {
            throw new WsGenException("Cannot get a deployable for the archive '" + var3_6 + "'", e);
        }
        if (localDeployable instanceof EARDeployable) {
            void var3_8;
            if (var3_6 instanceof JarArchive) {
                try {
                    localDeployable = UnpackDeployableHelper.unpack(localDeployable, "genbase");
                    FileArchive fileArchive = new FileArchive(URLUtils.urlToFile(localDeployable.getArchive().getURL()));
                }
                catch (Exception e) {
                    throw new GenBaseException("Cannot unpack the deployable '" + deployable + "'.", e);
                }
            }
            Application application = new Application((Archive)var3_8, localDeployable);
            mode = 0;
        } else if (localDeployable instanceof EJBDeployable) {
            EjbJar ejbJar = new EjbJar((Archive)var3_6);
            mode = 1;
        } else if (localDeployable instanceof WARDeployable) {
            WebApp webApp = new WebApp((Archive)var3_6);
            mode = 2;
        } else {
            if (!(localDeployable instanceof CARDeployable)) {
                String err = i18n.getMessage("ModifierFactory.getModifier.unsupported", filename);
                throw new WsGenException(err);
            }
            Client client = new Client((Archive)var3_6);
            mode = 3;
        }
        if (init) {
            var4_14.initialize();
        }
        switch (mode) {
            case 0: {
                ApplicationModifier applicationModifier = new ApplicationModifier((Application)var4_14);
                return var5_20;
            }
            case 1: {
                EjbJarModifier ejbJarModifier = new EjbJarModifier((EjbJar)var4_14);
                return var5_20;
            }
            case 2: {
                WebAppModifier webAppModifier = new WebAppModifier((WebApp)var4_14);
                return var5_20;
            }
            case 3: {
                ClientModifier clientModifier = new ClientModifier((Client)var4_14);
                return var5_20;
            }
        }
        return var5_20;
    }
}

