/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import javax.ejb.EJBException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JEntitySwitchCRC
extends JEntitySwitch {
    protected JEntityContext itContext = null;
    protected JEntityContext ihContext = null;

    public JEntitySwitchCRC() {
        this.lockpolicy = 2;
    }

    protected void initpolicy(JEntityFactory bf) {
        this.lazyregister = false;
    }

    protected JEntityContext getContext4Tx(Transaction tx) {
        JEntityContext ctx = null;
        ctx = tx == null ? this.ihContext : this.itContext;
        return ctx;
    }

    protected void setContext4Tx(Transaction tx, JEntityContext ctx) {
        if (tx == null) {
            this.ihContext = ctx;
        } else {
            this.itContext = ctx;
        }
    }

    protected void removeContext4Tx(Transaction tx) {
        if (tx == null) {
            this.ihContext = null;
        } else {
            this.itContext = null;
        }
    }

    public void waitmyturn(Transaction tx) {
        if (tx != null) {
            int waitcount = 0;
            Transaction lastrunning = null;
            while (this.runningtx != null && !tx.equals(this.runningtx)) {
                if (TraceEjb.isDebugSynchro()) {
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: WAIT end IT"));
                }
                this.blockedtx.add(tx);
                if (waitcount > 0 && this.runningtx.equals(lastrunning) && this.bf.isDeadLocked(this.runningtx)) {
                    this.blockedtx.remove(tx);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException e) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception setting rollbackonly"), (Throwable)e);
                    }
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                    throw new TransactionRolledbackLocalException("possible deadlock");
                }
                lastrunning = this.runningtx;
                ++waitcount;
                ++this.waiters;
                try {
                    this.wait(this.deadlockTimeout);
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: NOTIFIED"));
                    }
                }
                catch (InterruptedException e) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: INTERRUPTED"), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new EJBException("JEntitySwitch synchronization pb", e);
                }
                finally {
                    --this.waiters;
                    this.blockedtx.remove(tx);
                }
                int status = 4;
                try {
                    status = tx.getStatus();
                }
                catch (SystemException e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception getting transaction status"), (Throwable)e);
                }
                switch (status) {
                    case 1: 
                    case 4: 
                    case 9: {
                        if (TraceEjb.isVerbose()) {
                            TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                        }
                        throw new TransactionRolledbackLocalException("rollback occured while waiting");
                    }
                }
            }
        }
    }

    public synchronized int passivateIH(boolean store, boolean passivate) {
        long ttd = this.estimestamp - System.currentTimeMillis();
        if (ttd > 0L) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"too recent");
            return 2;
        }
        int icount = 0;
        JEntityContext jec = this.ihContext;
        if (jec != null && this.countIH == 0) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)("passivate: " + jec));
            }
            if (jec.passivate()) {
                this.bf.releaseJContext(jec, 1);
                this.ihContext = null;
                ++icount;
            }
        }
        if ((jec = this.itContext) != null && this.runningtx == null && this.countIT == 0) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)("passivated: " + jec));
            }
            if (jec.passivate()) {
                if (jec.getMyTx() != null) {
                    TraceEjb.context.log(BasicLevel.WARN, (Object)"Will forget Tx???");
                }
                this.bf.releaseJContext(jec, 1);
                this.itContext = null;
                ++icount;
            }
        }
        if (icount > 0 && this.waiters > 0) {
            this.notifyAll();
        }
        if (icount == 2) {
            if (this.inactivityTimeout > 0L && (ttd = this.inactivityTimeout + this.estimestamp - System.currentTimeMillis()) <= 0L) {
                this.detachPk();
                this.estimestamp = System.currentTimeMillis();
            }
            return 0;
        }
        return 2;
    }

    public synchronized void endIH() {
        TraceEjb.synchro.log(BasicLevel.ERROR, (Object)this.ident);
    }

    public int getState() {
        if (this.ihContext != null) {
            if (this.ihContext.isMarkedRemoved()) {
                return 4;
            }
            if (this.itContext == null) {
                return 2;
            }
        }
        if (this.itContext != null) {
            if (this.itContext.isMarkedRemoved()) {
                return 4;
            }
            if (this.runningtx != null) {
                return 0;
            }
            return 2;
        }
        return 3;
    }
}

