/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JMdbEndpointFactory;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.tm.TransactionManager;

public class JMessageEndpoint
implements MessageDrivenContext {
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    protected JMdbEndpointFactory bf = null;
    protected MessageDrivenBean mdb = null;
    protected MessageEndpoint mep = null;
    protected int txattr;
    protected TransactionManager tm = null;
    protected XAResource xar = null;
    protected boolean released = false;
    private static final int MAX_NB_RETRY = 2;
    private static final String DISALLOWED_MSG = " is disallowed in a message driven bean";

    public JMessageEndpoint(JMdbEndpointFactory bf, MessageDrivenBean mdb) {
        this.bf = bf;
        this.mdb = mdb;
        this.txattr = bf.getTransactionAttribute();
        this.tm = bf.getTransactionManager();
    }

    public void setProxy(MessageEndpoint mep) {
        this.mep = mep;
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    public void setXAResource(XAResource xa) {
        this.xar = xa;
    }

    public boolean getReleasedState() {
        return this.released;
    }

    public void setReleasedState(boolean state) {
        this.released = state;
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.bf.getTimerService();
    }

    public Identity getCallerIdentity() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getCallerIdentity() is disallowed in a message driven bean");
    }

    public Principal getCallerPrincipal() {
        Principal principal;
        SecurityContext sctx;
        SecurityCurrent current;
        boolean inRunAs = false;
        if (this.bf.dd.getRunAsRole() != null) {
            inRunAs = true;
        }
        if ((current = SecurityCurrent.getCurrent()) != null && (sctx = current.getSecurityContext()) == null) {
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)"runas : Security context is null, create a new one");
            }
            sctx = new SecurityContext();
            current.setSecurityContext(sctx);
        }
        if ((principal = this.bf.getContainer().getPrincipalFactory().getCallerPrincipal(inRunAs)) == null) {
            throw new IllegalStateException("No principal exists in security context");
        }
        return principal;
    }

    public boolean isCallerInRole(Identity role) {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("isCallerInRole() is disallowed in a message driven bean");
    }

    public boolean isCallerInRole(String roleLink) {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("isCallerInRole() is disallowed in a message driven bean");
    }

    public void setRollbackOnly() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.bf.isTxBeanManaged()) {
            throw new IllegalStateException("Bean-managed transaction, not use this method.");
        }
        try {
            this.tm.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"current thread not associated with transaction");
            throw e;
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"unexpected exception:", (Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.bf.isTxBeanManaged()) {
            throw new IllegalStateException("Bean-managed transaction, not use this method.");
        }
        try {
            if (this.tm.getTransaction() != null) {
                switch (this.tm.getStatus()) {
                    case 1: 
                    case 4: 
                    case 9: {
                        return true;
                    }
                    case 6: {
                        throw new IllegalStateException("No transaction");
                    }
                }
                return false;
            }
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"the bean is not associated in a transaction");
            throw new IllegalStateException("the message driven bean is not associated in a transaction");
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot get status:", (Throwable)e);
            return false;
        }
    }

    public EJBHome getEJBHome() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getEJBHome() is disallowed in a message driven bean");
    }

    public EJBLocalHome getEJBLocalHome() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getEJBLocalHome() is disallowed in a message driven bean");
    }

    public Properties getEnvironment() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)"deprecated use : Use the JNDI naming context java:comp/env");
        return new Properties();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.bf.isTxBeanManaged()) {
            throw new IllegalStateException("This bean is not allowed to use UserTransaction interface");
        }
        return (UserTransaction)((Object)this.tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverTimeout(Timer timer) {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        boolean committed = false;
        for (int nbretry = 0; !committed && nbretry < 2; ++nbretry) {
            RequestCtx rctx = null;
            try {
                rctx = this.bf.preInvoke(2);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"preInvoke failed: ", (Throwable)e);
                return;
            }
            try {
                this.bf.checkSecurity(null);
                if (!(this.mdb instanceof TimedObject)) {
                    throw new EJBException("The bean does not implement the `TimedObject` interface");
                }
                ((TimedObject)((Object)this.mdb)).ejbTimeout(timer);
                committed = !this.getRollbackOnly();
                continue;
            }
            catch (EJBException e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"EJB exception thrown by an enterprise Bean", (Throwable)e);
                continue;
            }
            catch (RuntimeException e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"runtime exception thrown by an enterprise Bean", (Throwable)e);
                continue;
            }
            catch (Error e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"error thrown by an enterprise Bean", (Throwable)e);
                continue;
            }
            finally {
                try {
                    this.bf.postInvoke(rctx);
                }
                catch (Exception e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception on postInvoke: ", (Throwable)e);
                }
            }
        }
    }

    public Object lookup(String name) {
        try {
            return new InitialContext().lookup(JAVA_COMP_ENV + name);
        }
        catch (NamingException ne) {
            try {
                return new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Lookup on '" + name + "' was not found");
            }
        }
    }
}

