/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.carol.rmi.exception.RmiUtility;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JRemote;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionHandle;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.svc.JHandleIIOP;

public abstract class JSessionRemote
extends JRemote
implements Remote {
    protected JSessionSwitch bs;

    public JSessionRemote(JSessionFactory bf) throws RemoteException {
        super(bf);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    public abstract void remove() throws RemoteException, RemoveException;

    public EJBHome getEJBHome() {
        return this.bf.getHome();
    }

    public Object getPrimaryKey() throws RemoteException {
        try {
            throw new RemoteException("Session bean has no primary key");
        }
        catch (RemoteException e) {
            RmiUtility.rethrowRmiException(e);
            throw e;
        }
    }

    public boolean isIdentical(EJBObject obj) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            boolean ret = false;
            JSessionFactory sf = (JSessionFactory)this.bf;
            if (sf.isStateful()) {
                if (obj != null) {
                    ret = obj.equals(PortableRemoteObject.toStub((Remote)this)) || obj.equals(this);
                }
            } else {
                String myhome = this.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName();
                if (obj != null) {
                    ret = obj.getEJBHome().getEJBMetaData().getHomeInterfaceClass().getName().equals(myhome);
                }
            }
            return ret;
        }
        catch (RemoteException e) {
            RmiUtility.rethrowRmiException(e);
            throw e;
        }
    }

    public Handle getHandle() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (TraceEjb.interp.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Current protocol = " + protocol));
        }
        if (protocol.equals("iiop")) {
            return new JHandleIIOP(this);
        }
        return new JSessionHandle(this);
    }

    public void setSessionSwitch(JSessionSwitch bs) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bs = bs;
    }

    public JSessionSwitch getSessionSwitch() {
        return this.bs;
    }

    public RequestCtx preInvoke(int txa) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        RequestCtx rctx = this.bf.preInvokeRemote(txa);
        this.bs.setMustCommit(rctx.mustCommit);
        this.bs.enlistConnections(rctx.currTx);
        return rctx;
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.checkSecurity(ejbInv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RequestCtx rctx) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bs.delistConnections(rctx.currTx);
        this.bs.saveBeanTx();
        try {
            this.bf.postInvokeRemote(rctx);
            this.bs.releaseICtx(rctx, rctx.sysExc != null);
        }
        catch (Throwable throwable) {
            this.bs.releaseICtx(rctx, rctx.sysExc != null);
            throw throwable;
        }
    }
}

