/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.reconfig.actuator;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.reconfig.ReconfigException;
import org.ow2.jonas.lib.management.reconfig.actuator.BaseConfigurationActuator;

public class PropertiesConfigurationActuator
extends BaseConfigurationActuator {
    private Properties stableConfig;
    private Properties currentConfig;

    public PropertiesConfigurationActuator(String name, String configFileName, Properties config) {
        super(name, configFileName);
        this.stableConfig = config;
        this.currentConfig = new Properties();
    }

    public void updateConfig(String key, String value, long sequence) {
        if (sequence > this.lastSequence) {
            this.currentConfig.setProperty(key, value);
            this.lastSequence = sequence;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("- " + sequence + " - Recufigured property to update " + key + " with value : " + value));
            }
        } else {
            logger.log(BasicLevel.WARN, (Object)"Received out of order reconfiguration message !");
            logger.log(BasicLevel.WARN, (Object)("Reconfiguration value for property " + key + " : " + value + " lost!"));
        }
    }

    public void updateConfig(String key, String value, boolean add, long sequence) {
        if (sequence > this.lastSequence) {
            String oldValue = this.currentConfig.getProperty(key);
            if (oldValue == null) {
                oldValue = this.stableConfig.getProperty(key);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("- " + sequence + " - Recufigured property to update " + key + " having value : " + oldValue));
            }
            String newValue = this.updateValue(oldValue, value, add);
            this.currentConfig.setProperty(key, newValue);
            this.lastSequence = sequence;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("- " + sequence + " - Updated property " + key + " with value : " + newValue));
            }
        } else {
            logger.log(BasicLevel.WARN, (Object)"Received out of order reconfiguration message !");
            logger.log(BasicLevel.WARN, (Object)("Reconfiguration value for property " + key + " : " + value + " lost!"));
        }
    }

    public void updateConfig(Properties props, long sequence) {
        if (sequence > this.lastSequence) {
            Enumeration<?> pNames = props.propertyNames();
            while (pNames.hasMoreElements()) {
                String aName = (String)pNames.nextElement();
                String aValue = props.getProperty(aName);
                if (aValue == null) continue;
                this.currentConfig.setProperty(aName, aValue);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("- " + sequence + " - Updated property " + aName + " with value : " + aValue));
            }
            this.lastSequence = sequence;
        } else {
            logger.log(BasicLevel.WARN, (Object)"Received out of order reconfiguration message !");
        }
    }

    public String updateValue(String oldValue, String value, boolean add) {
        String returnValue;
        value = value.trim();
        oldValue = oldValue.trim();
        if (add) {
            returnValue = new String(oldValue);
            returnValue = returnValue + ',' + value;
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Remove " + value + " from " + oldValue));
            }
            returnValue = new String();
            boolean firstToken = true;
            StringTokenizer st = new StringTokenizer(oldValue, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.equals(value)) continue;
                if (firstToken) {
                    returnValue = new String(token);
                    firstToken = false;
                    continue;
                }
                returnValue = returnValue + ',' + token;
            }
        }
        return returnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveConfig(long sequence) throws ReconfigException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (sequence > this.lastSequence) {
            Enumeration<Object> props = this.currentConfig.keys();
            while (props.hasMoreElements()) {
                String reconfiguredProp = (String)props.nextElement();
                String reconfiguredPropValue = this.currentConfig.getProperty(reconfiguredProp);
                this.stableConfig.setProperty(reconfiguredProp, reconfiguredPropValue);
            }
            try {
                FileOutputStream fo = new FileOutputStream(this.configFileName);
                this.stableConfig.store(fo, "Saved configuration file at ");
                fo.close();
                this.lastSequence = sequence;
                if (!logger.isLoggable(BasicLevel.DEBUG)) return;
                logger.log(BasicLevel.DEBUG, (Object)("Configuration file " + this.configFileName + " updated"));
                return;
            }
            catch (FileNotFoundException e) {
                throw new ReconfigException("Cant' save configuration file: " + e.toString());
            }
            catch (IOException ioe) {
                throw new ReconfigException("Cant' save configuration file: " + ioe.toString());
            }
        } else {
            logger.log(BasicLevel.WARN, (Object)("Received out of order save reconfiguration message for " + this.name + " !"));
            logger.log(BasicLevel.WARN, (Object)"Can not save !!");
            logger.log(BasicLevel.WARN, (Object)"Please reconfigure and than save !!");
            this.currentConfig = new Properties();
        }
    }
}

