/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.iiop;

import java.io.UnsupportedEncodingException;
import org.objectweb.util.monolog.api.Logger;
import org.omg.GSSUP.InitialContextToken;
import org.ow2.carol.util.csiv2.gss.GSSHelper;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.internal.AbsSecurityContextHelper;

public class SecurityContextHelper
extends AbsSecurityContextHelper {
    private static SecurityContextHelper instance = null;
    private static final String CSIV2_REALM_KEY = "jonas.service.security.csiv2.realm";
    private static final String DEFAULT_CSIV2_REALM = "memrlm_1";
    private static final String DOMAIN_SEPARATOR = "@";
    private static final String DEFAULT_DOMAIN_NAME = "default";
    private static final String ENCODING = "UTF-8";
    private static Logger logger = Log.getLogger("org.ow2.jonas.security.csiv2");

    private SecurityContextHelper() {
    }

    public static SecurityContextHelper getInstance() {
        if (instance == null) {
            instance = new SecurityContextHelper();
        }
        return instance;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected String getRealmKey() {
        return CSIV2_REALM_KEY;
    }

    protected String getRealmDefault() {
        return DEFAULT_CSIV2_REALM;
    }

    protected void loginAuthenticationToken(String userName, String password) {
        String principalName = userName.split(DOMAIN_SEPARATOR)[0];
        String credential = password;
        this.login(principalName, credential);
    }

    protected void loginIdentiyToken(String principalName) {
        String credential = principalName;
        this.login(principalName, credential);
    }

    public String getIdentityToken() {
        SecurityCurrent current = SecurityCurrent.getCurrent();
        SecurityContext securityContext = current.getSecurityContext();
        if (securityContext.peekRunAsPrincipal() != null) {
            return securityContext.peekRunAsPrincipal();
        }
        return securityContext.getCallerPrincipal(false).getName();
    }

    public InitialContextToken getInitialContextToken() throws UnsupportedEncodingException {
        SecurityCurrent current = SecurityCurrent.getCurrent();
        SecurityContext securityContext = current.getSecurityContext();
        String principalName = securityContext.getPrincipalName();
        String userName = principalName + DOMAIN_SEPARATOR + DEFAULT_DOMAIN_NAME;
        String password = principalName;
        byte[] user = userName.getBytes(ENCODING);
        byte[] pass = password.getBytes(ENCODING);
        byte[] domain = GSSHelper.encodeExported(DEFAULT_DOMAIN_NAME);
        return new InitialContextToken(user, pass, domain);
    }
}

