/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base;

import org.ow2.jonas.web.JWebContainerService;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARDeployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(WARDeployer.class);
    private JWebContainerService webContainerService = null;

    @Override
    public void doDeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info("Deploying {0}", deployable);
        try {
            this.webContainerService.registerWar(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the War deployable '" + deployable + "'.", e);
        }
    }

    @Override
    public void doUndeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info("Undeploying {0}", deployable);
        try {
            this.webContainerService.unRegisterWar(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the War deployable '" + deployable + "'.", e);
        }
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof WARDeployable;
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }
}

